/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementDetailsStandard;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupNone;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupSingleTable;
import org.hibernate.engine.jdbc.mutation.internal.PreparedStatementGroupStandard;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.MutationStatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.jdbc.TooManyRowsAffectedException;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.stat.spi.StatisticsImplementor;

public class ModelMutationHelper {
    private ModelMutationHelper() {
    }

    public static void checkResults(OperationResultChecker resultChecker, PreparedStatementDetails statementDetails, int affectedRowCount, int batchPosition) throws SQLException {
        if (resultChecker != null) {
            resultChecker.checkResult(statementDetails, affectedRowCount, batchPosition);
        }
    }

    public static boolean identifiedResultsCheck(PreparedStatementDetails statementDetails, int affectedRowCount, int batchPosition, MutationTarget<?> mutationTarget, Object id, SessionFactoryImplementor sessionFactory) {
        try {
            statementDetails.getExpectation().verifyOutcome(affectedRowCount, statementDetails.getStatement(), batchPosition, statementDetails.getSqlString());
        }
        catch (StaleStateException e) {
            if (!statementDetails.getMutatingTableDetails().isOptional()) {
                if (affectedRowCount == 0) {
                    StatisticsImplementor statistics = sessionFactory.getStatistics();
                    if (statistics.isStatisticsEnabled()) {
                        statistics.optimisticFailure(mutationTarget.getNavigableRole().getFullPath());
                    }
                    throw new StaleObjectStateException(mutationTarget.getNavigableRole().getFullPath(), id);
                }
            }
        }
        catch (TooManyRowsAffectedException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Duplicate identifier in table (%s) - %s#%s", statementDetails.getMutatingTableDetails().getTableName(), mutationTarget.getNavigableRole().getFullPath(), id));
        }
        finally {
            return false;
        }
        return true;
    }

    public static PreparedStatementGroup toPreparedStatementGroup(MutationType mutationType, MutationTarget<?> mutationTarget, GeneratedValuesMutationDelegate delegate, List<PreparableMutationOperation> mutations, SharedSessionContractImplementor session) {
        if (mutations == null || mutations.isEmpty()) {
            return PreparedStatementGroupNone.GROUP_OF_NONE;
        }
        if (mutations.size() == 1) {
            return new PreparedStatementGroupSingleTable(mutations.get(0), delegate, session);
        }
        return new PreparedStatementGroupStandard(mutationType, mutationTarget, delegate, mutations, session);
    }

    public static PreparedStatementDetails standardPreparation(PreparableMutationOperation jdbcMutation, GeneratedValuesMutationDelegate delegate, SharedSessionContractImplementor session) {
        return new PreparedStatementDetailsStandard(jdbcMutation, () -> delegate != null ? ModelMutationHelper.delegateStatementPreparation(jdbcMutation, delegate, session) : ModelMutationHelper.standardStatementPreparation(jdbcMutation, session), session.getJdbcServices());
    }

    public static PreparedStatement delegateStatementPreparation(PreparableMutationOperation jdbcMutation, GeneratedValuesMutationDelegate delegate, SharedSessionContractImplementor session) {
        PreparedStatement statement = delegate.prepareStatement(jdbcMutation.getSqlString(), session);
        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().register(null, statement);
        return statement;
    }

    public static PreparedStatement standardStatementPreparation(PreparableMutationOperation jdbcMutation, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        MutationStatementPreparer statementPreparer = jdbcCoordinator.getMutationStatementPreparer();
        PreparedStatement statement = statementPreparer.prepareStatement(jdbcMutation.getSqlString(), jdbcMutation.isCallable());
        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().register(null, statement);
        return statement;
    }
}

