/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.Serializable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.hibernate.engine.spi.EntityKey;

public final class AssociationKey
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized EntityKey ownerKey;
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;

    public AssociationKey(@UnknownKeyFor @NonNull @Initialized EntityKey ownerKey, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.ownerKey = ownerKey;
        this.propertyName = propertyName;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationKey that = (AssociationKey)o;
        return this.ownerKey.equals(that.ownerKey) && this.propertyName.equals(that.propertyName);
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        int result = this.ownerKey.hashCode();
        result = 31 * result + this.propertyName.hashCode();
        return result;
    }
}

