/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SoftDeletableModelPart;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaType;

public class SoftDeleteMappingImpl
implements SoftDeleteMapping {
    public static final String ROLE_NAME = "{soft-delete}";
    private final SoftDeletableModelPart softDeletable;
    private final String columnName;
    private final String tableName;
    private final Object deletedLiteralValue;
    private final String deletedLiteralText;
    private final Object nonDeletedLiteralValue;
    private final String nonDeletedLiteralText;
    private final JdbcMapping jdbcMapping;
    private final NavigableRole navigableRole;

    public SoftDeleteMappingImpl(SoftDeletableModelPart softDeletable, String columnName, String tableName, Object deletedLiteralValue, String deletedLiteralText, Object nonDeletedLiteralValue, String nonDeletedLiteralText, JdbcMapping jdbcMapping) {
        this.softDeletable = softDeletable;
        this.columnName = columnName;
        this.tableName = tableName;
        this.deletedLiteralValue = deletedLiteralValue;
        this.deletedLiteralText = deletedLiteralText;
        this.nonDeletedLiteralValue = nonDeletedLiteralValue;
        this.nonDeletedLiteralText = nonDeletedLiteralText;
        this.jdbcMapping = jdbcMapping;
        this.navigableRole = softDeletable.getNavigableRole().append(ROLE_NAME);
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Object getDeletedLiteralValue() {
        return this.deletedLiteralValue;
    }

    @Override
    public String getDeletedLiteralText() {
        return this.deletedLiteralText;
    }

    @Override
    public Object getNonDeletedLiteralValue() {
        return this.nonDeletedLiteralValue;
    }

    @Override
    public String getNonDeletedLiteralText() {
        return this.nonDeletedLiteralText;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public String getPartName() {
        return ROLE_NAME;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return 1;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, x, y, value, this.getJdbcMapping());
        return 1;
    }

    @Override
    public MappingType getPartMappingType() {
        return this.jdbcMapping;
    }

    @Override
    public JavaType<?> getJavaType() {
        return this.jdbcMapping.getMappedJavaType();
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, creationState);
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.getJdbcMapping(), navigablePath, false, !sqlSelection.isVirtual());
    }

    private SqlSelection resolveSqlSelection(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        TableDetails indicatorTable = this.softDeletable.getSoftDeleteTableDetails();
        TableReference tableReference = tableGroup.resolveTableReference(navigablePath.getRealParent(), indicatorTable.getTableName());
        SqlExpressionResolver expressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = expressionResolver.resolveSqlSelection(expressionResolver.resolveSqlExpression(tableReference, this), this.getJavaType(), null, creationState.getSqlAstCreationState().getCreationContext().getMappingMetamodel().getTypeConfiguration());
        return sqlSelection;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.resolveSqlSelection(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        SqlSelection sqlSelection = this.resolveSqlSelection(navigablePath, tableGroup, creationState);
        selectionConsumer.accept(sqlSelection, this.getJdbcMapping());
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(offset, x, y, this.disassemble(domainValue, session), this);
        return 1;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.softDeletable.findContainingEntityMapping();
    }

    public String toString() {
        return "SoftDeleteMappingImpl(" + this.tableName + "." + this.columnName + ")";
    }
}

