/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityPersisterConcurrentMap {
    private final ConcurrentHashMap<String, EntityPersisterHolder> map = new ConcurrentHashMap();
    private volatile EntityPersister[] values = new EntityPersister[0];
    private volatile String[] keys = new String[0];

    public EntityPersister get(String name) {
        EntityPersisterHolder entityPersisterHolder = this.map.get(name);
        if (entityPersisterHolder != null) {
            return entityPersisterHolder.entityPersister;
        }
        return null;
    }

    public EntityPersister[] values() {
        return this.values;
    }

    public synchronized void put(String name, EntityPersister entityPersister) {
        this.map.put(name, new EntityPersisterHolder(entityPersister));
        this.recomputeValues();
    }

    public synchronized void putIfAbsent(String name, EntityPersister entityPersister) {
        this.map.putIfAbsent(name, new EntityPersisterHolder(entityPersister));
        this.recomputeValues();
    }

    public boolean containsKey(String name) {
        return this.map.containsKey(name);
    }

    public String[] keys() {
        return this.keys;
    }

    private void recomputeValues() {
        int size = this.map.size();
        EntityPersister[] newValues = new EntityPersister[size];
        String[] newKeys = new String[size];
        int i = 0;
        for (Map.Entry<String, EntityPersisterHolder> e : this.map.entrySet()) {
            newValues[i] = e.getValue().entityPersister;
            newKeys[i] = e.getKey();
            ++i;
        }
        this.values = newValues;
        this.keys = newKeys;
    }

    @Deprecated(forRemoval=true)
    public Map<String, EntityPersister> convertToMap() {
        return this.map.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((EntityPersisterHolder)e.getValue()).entityPersister));
    }

    private static final class EntityPersisterHolder {
        private final EntityPersister entityPersister;

        EntityPersisterHolder(EntityPersister entityPersister) {
            Objects.requireNonNull(entityPersister);
            this.entityPersister = entityPersister;
        }
    }
}

