/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal;

import java.util.function.Function;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.mutation.internal.ExpressionDomainResultProducer;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.expression.SqmSelfRenderingExpression;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class SelectableMappingExpressionConverter
implements Function<SemanticQueryWalker, Expression> {
    private final NavigablePath navigablePath;
    private final SelectableMapping selectableMapping;

    private SelectableMappingExpressionConverter(NavigablePath navigablePath, SelectableMapping selectableMapping) {
        this.navigablePath = navigablePath;
        this.selectableMapping = selectableMapping;
    }

    public static SqmSelection<Object> forSelectableMapping(SqmFrom<?, ?> from, SelectableMapping selectableMapping) {
        return new SqmSelection<Object>(new SqmSelfRenderingExpression(new SelectableMappingExpressionConverter(from.getNavigablePath(), selectableMapping), (SqmExpressible)((Object)selectableMapping.getJdbcMapping()), from.nodeBuilder()), from.nodeBuilder());
    }

    @Override
    public Expression apply(SemanticQueryWalker semanticQueryWalker) {
        SqmToSqlAstConverter converter = (SqmToSqlAstConverter)semanticQueryWalker;
        TableGroup tableGroup = converter.getFromClauseAccess().getTableGroup(this.navigablePath);
        Expression expression = converter.getCurrentProcessingState().getSqlExpressionResolver().resolveSqlExpression(tableGroup.getTableReference(this.selectableMapping.getContainingTableExpression()), this.selectableMapping);
        return new ExpressionDomainResultProducer(expression);
    }
}

