/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import org.hibernate.Internal;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmCollation;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.JavaObjectType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class ArgumentTypesValidator
implements ArgumentsValidator {
    final ArgumentsValidator delegate;
    private final FunctionParameterType[] types;

    public ArgumentTypesValidator(ArgumentsValidator delegate, FunctionParameterType ... types) {
        this.types = types;
        if (delegate == null) {
            delegate = StandardArgumentsValidators.exactly(types.length);
        }
        this.delegate = delegate;
    }

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        this.delegate.validate(arguments, functionName, typeConfiguration);
        int count = 0;
        for (SqmTypedNode<?> argument : arguments) {
            FunctionParameterType type;
            SqmExpressible<?> nodeType = argument.getNodeType();
            FunctionParameterType functionParameterType = type = count < this.types.length ? this.types[count++] : this.types[this.types.length - 1];
            if (nodeType == null || type == FunctionParameterType.ANY) continue;
            JavaType<?> javaType = nodeType.getRelationalJavaType();
            if (javaType != null) {
                this.checkArgumentType(functionName, count, argument, type, javaType);
            }
            switch (type) {
                case TEMPORAL_UNIT: {
                    if (argument instanceof SqmExtractUnit || argument instanceof SqmDurationUnit) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case TRIM_SPEC: {
                    if (argument instanceof SqmTrimSpecification) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case COLLATION: {
                    if (argument instanceof SqmCollation) break;
                    ArgumentTypesValidator.throwError(type, Object.class, null, functionName, count);
                    break;
                }
                case NO_UNTYPED: {
                    if (!(argument instanceof SqmLiteralNull)) break;
                    throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' does not permit untyped expressions like null literals. Please cast the expression to a type", count, functionName));
                }
            }
        }
    }

    private void checkArgumentType(String functionName, int count, SqmTypedNode<?> argument, FunctionParameterType type, JavaType<?> javaType) {
        DomainType<?> domainType;
        if (!JavaTypeHelper.isUnknown(javaType) && (domainType = argument.getExpressible().getSqmType()) instanceof JdbcMapping) {
            JdbcMapping jdbcMapping = (JdbcMapping)((Object)domainType);
            ArgumentTypesValidator.checkArgumentType(count, functionName, type, jdbcMapping.getJdbcType(), javaType.getJavaTypeClass());
        }
    }

    @Override
    public void validateSqlTypes(List<? extends SqlAstNode> arguments, String functionName) {
        int count = 0;
        for (SqlAstNode sqlAstNode : arguments) {
            Expression expression;
            JdbcMappingContainer expressionType;
            if (!(sqlAstNode instanceof Expression) || (expressionType = (expression = (Expression)sqlAstNode).getExpressionType()) == null) continue;
            if (ArgumentTypesValidator.isUnknownExpressionType(expressionType)) {
                count += expressionType.getJdbcTypeCount();
                continue;
            }
            count = this.validateArgument(count, expressionType, functionName);
        }
    }

    private static boolean isUnknownExpressionType(JdbcMappingContainer expressionType) {
        return expressionType instanceof JavaObjectType || expressionType instanceof BasicType && JavaTypeHelper.isUnknown(((BasicType)expressionType).getJavaTypeDescriptor());
    }

    private int validateArgument(int paramNumber, JdbcMappingContainer expressionType, String functionName) {
        int jdbcTypeCount = expressionType.getJdbcTypeCount();
        for (int i = 0; i < jdbcTypeCount; ++i) {
            FunctionParameterType type;
            JdbcMapping mapping = expressionType.getJdbcMapping(i);
            FunctionParameterType functionParameterType = type = paramNumber < this.types.length ? this.types[paramNumber++] : this.types[this.types.length - 1];
            if (type == null) continue;
            ArgumentTypesValidator.checkArgumentType(paramNumber, functionName, type, mapping.getJdbcType(), mapping.getJavaTypeDescriptor().getJavaType());
        }
        return paramNumber;
    }

    private static void checkArgumentType(int paramNumber, String functionName, FunctionParameterType type, JdbcType jdbcType, Type javaType) {
        if (!(ArgumentTypesValidator.isCompatible(type, jdbcType) || type == FunctionParameterType.COMPARABLE && ArgumentTypesValidator.isBinaryUuid(jdbcType, javaType))) {
            ArgumentTypesValidator.throwError(type, javaType, jdbcType.getFriendlyName(), functionName, paramNumber);
        }
    }

    private static boolean isBinaryUuid(JdbcType jdbcType, Type javaType) {
        return javaType == UUID.class && jdbcType.isBinary();
    }

    @Internal
    private static boolean isCompatible(FunctionParameterType type, JdbcType jdbcType) {
        switch (type) {
            case COMPARABLE: {
                return jdbcType.isComparable();
            }
            case STRING: {
                return jdbcType.isStringLikeExcludingClob();
            }
            case STRING_OR_CLOB: {
                return jdbcType.isString();
            }
            case NUMERIC: {
                return jdbcType.isNumber();
            }
            case INTEGER: {
                return jdbcType.isInteger();
            }
            case BOOLEAN: {
                return jdbcType.isBoolean() || jdbcType.isSmallInteger();
            }
            case TEMPORAL: {
                return jdbcType.isTemporal();
            }
            case DATE: {
                return jdbcType.hasDatePart();
            }
            case TIME: {
                return jdbcType.hasTimePart();
            }
            case SPATIAL: {
                return jdbcType.isSpatial();
            }
        }
        return true;
    }

    private static void throwError(FunctionParameterType type, Type javaType, String sqlType, String functionName, int paramNumber) {
        if (sqlType == null) {
            throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type '%s', but argument is of type '%s'", new Object[]{paramNumber, functionName, type, javaType.getTypeName()}));
        }
        throw new FunctionArgumentException(String.format("Parameter %d of function '%s()' has type '%s', but argument is of type '%s' mapped to '%s'", new Object[]{paramNumber, functionName, type, javaType.getTypeName(), sqlType}));
    }

    @Override
    public String getSignature() {
        String sig = this.delegate.getSignature();
        for (int i = 0; i < this.types.length; ++i) {
            Object argName = this.types.length == 1 ? "arg" : "arg" + i;
            sig = sig.replace((CharSequence)argName, this.types[i] + " " + (String)argName);
        }
        return sig;
    }
}

