/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmAliasedNodeRef;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;

public class SqmOrderByClause
implements Serializable {
    private boolean hasPositionalSortItem;
    private List<SqmSortSpecification> sortSpecifications;

    public SqmOrderByClause() {
    }

    public SqmOrderByClause(int estimateSize) {
        this.sortSpecifications = new ArrayList<SqmSortSpecification>(estimateSize);
    }

    private SqmOrderByClause(boolean hasPositionalSortItem, List<SqmSortSpecification> sortSpecifications) {
        this.hasPositionalSortItem = hasPositionalSortItem;
        this.sortSpecifications = sortSpecifications;
    }

    public SqmOrderByClause copy(SqmCopyContext context) {
        ArrayList<SqmSortSpecification> sortSpecifications;
        if (this.sortSpecifications == null) {
            sortSpecifications = null;
        } else {
            sortSpecifications = new ArrayList<SqmSortSpecification>(this.sortSpecifications.size());
            for (SqmSortSpecification sortSpecification : this.sortSpecifications) {
                sortSpecifications.add(sortSpecification.copy(context));
            }
        }
        return new SqmOrderByClause(this.hasPositionalSortItem, sortSpecifications);
    }

    public boolean hasPositionalSortItem() {
        return this.hasPositionalSortItem;
    }

    public SqmOrderByClause addSortSpecification(SqmSortSpecification sortSpecification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SqmSortSpecification>();
        }
        this.sortSpecifications.add(sortSpecification);
        if (sortSpecification.getExpression() instanceof SqmAliasedNodeRef) {
            this.hasPositionalSortItem = true;
        }
        return this;
    }

    public SqmOrderByClause addSortSpecification(SqmExpression<?> expression) {
        this.addSortSpecification(new SqmSortSpecification(expression));
        return this;
    }

    public List<SqmSortSpecification> getSortSpecifications() {
        return this.sortSpecifications == null ? Collections.emptyList() : Collections.unmodifiableList(this.sortSpecifications);
    }

    public void setSortSpecifications(List<SqmSortSpecification> sortSpecifications) {
        this.sortSpecifications = new ArrayList<SqmSortSpecification>();
        this.sortSpecifications.addAll(sortSpecifications);
        this.hasPositionalSortItem = false;
        for (int i = 0; i < sortSpecifications.size(); ++i) {
            SqmSortSpecification sortSpecification = sortSpecifications.get(i);
            if (!(sortSpecification.getExpression() instanceof SqmAliasedNodeRef)) continue;
            this.hasPositionalSortItem = true;
        }
    }
}

