/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spi;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Incubating;
import org.hibernate.spi.DotIdentifierSequence;
import org.hibernate.spi.NavigablePath;

@Incubating
public class EntityIdentifierNavigablePath
extends NavigablePath {
    private final @UnknownKeyFor @NonNull @Initialized String identifierAttributeName;

    public EntityIdentifierNavigablePath(@UnknownKeyFor @NonNull @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String identifierAttributeName) {
        super(parent, "{id}");
        this.identifierAttributeName = identifierAttributeName;
    }

    public EntityIdentifierNavigablePath(@UnknownKeyFor @NonNull @Initialized NavigablePath parent, @UnknownKeyFor @NonNull @Initialized String alias, @UnknownKeyFor @NonNull @Initialized String identifierAttributeName) {
        super(parent, "{id}", alias);
        this.identifierAttributeName = identifierAttributeName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getIdentifierAttributeName() {
        return this.identifierAttributeName;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getLocalName() {
        return "{id}";
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean localNamesMatch(@UnknownKeyFor @NonNull @Initialized DotIdentifierSequence otherPath) {
        String otherLocalName = otherPath.getLocalName();
        return otherLocalName.equals(this.getLocalName()) || otherLocalName.equals(this.identifierAttributeName);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized boolean localNamesMatch(@UnknownKeyFor @NonNull @Initialized EntityIdentifierNavigablePath otherPath) {
        return super.localNamesMatch(otherPath);
    }
}

