/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.internal;

import io.github.resilience4j.core.ConfigurationNotFoundException;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.AbstractRegistry;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public final class InMemoryRetryRegistry
extends AbstractRegistry<Retry, RetryConfig>
implements RetryRegistry {
    public InMemoryRetryRegistry() {
        this(RetryConfig.ofDefaults());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs) {
        this(configs, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer) {
        this(configs, registryEventConsumer, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, RegistryEventConsumer<Retry> registryEventConsumer, Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumer, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        this(configs, registryEventConsumers, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers, Map<String, String> tags) {
        this(configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumers, tags);
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(Map<String, RetryConfig> configs, List<RegistryEventConsumer<Retry>> registryEventConsumers, Map<String, String> tags, RegistryStore<Retry> registryStore) {
        super((Object)configs.getOrDefault("default", RetryConfig.ofDefaults()), registryEventConsumers, Optional.ofNullable(tags).orElse(Collections.emptyMap()), Optional.ofNullable(registryStore).orElse((RegistryStore<Retry>)new InMemoryRegistryStore()));
        this.configurations.putAll(configs);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig) {
        this(defaultConfig, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, Map<String, String> tags) {
        super((Object)defaultConfig, tags);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, RegistryEventConsumer<Retry> registryEventConsumer) {
        this(defaultConfig, registryEventConsumer, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, RegistryEventConsumer<Retry> registryEventConsumer, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumer, tags);
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers) {
        this(defaultConfig, registryEventConsumers, Collections.emptyMap());
    }

    public InMemoryRetryRegistry(RetryConfig defaultConfig, List<RegistryEventConsumer<Retry>> registryEventConsumers, Map<String, String> tags) {
        super((Object)defaultConfig, registryEventConsumers, tags);
    }

    @Override
    public Set<Retry> getAllRetries() {
        return new HashSet<Retry>(this.entryMap.values());
    }

    @Override
    public Retry retry(String name) {
        return this.retry(name, (RetryConfig)this.getDefaultConfig());
    }

    @Override
    public Retry retry(String name, Map<String, String> tags) {
        return this.retry(name, (RetryConfig)this.getDefaultConfig(), tags);
    }

    @Override
    public Retry retry(String name, RetryConfig config) {
        return this.retry(name, config, Collections.emptyMap());
    }

    @Override
    public Retry retry(String name, RetryConfig config, Map<String, String> tags) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, Objects.requireNonNull(config, "Config must not be null"), (Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier) {
        return this.retry(name, retryConfigSupplier, Collections.emptyMap());
    }

    @Override
    public Retry retry(String name, Supplier<RetryConfig> retryConfigSupplier, Map<String, String> tags) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, Objects.requireNonNull((RetryConfig)Objects.requireNonNull(retryConfigSupplier, "Supplier must not be null").get(), "Config must not be null"), (Map<String, String>)this.getAllTags(tags)));
    }

    @Override
    public Retry retry(String name, String configName) {
        return this.retry(name, configName, Collections.emptyMap());
    }

    @Override
    public Retry retry(String name, String configName, Map<String, String> tags) {
        return (Retry)this.computeIfAbsent(name, () -> Retry.of(name, (RetryConfig)this.getConfiguration(configName).orElseThrow(() -> new ConfigurationNotFoundException(configName)), (Map<String, String>)this.getAllTags(tags)));
    }
}

