/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class GenericType<T> {
    private final Type type;

    public GenericType() {
        if (GenericType.class != this.getClass().getSuperclass()) {
            String errorMsg = "'%s' must be a direct subclass of '%s'";
            errorMsg = String.format(errorMsg, this.getClass().getName(), GenericType.class.getName());
            throw new IllegalArgumentException(errorMsg);
        }
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            String message = "'%s' must be parameterized (for example \"new GenericType<List<Integer>>(){}\"), it can not be of raw type \"new GenericType(){}\".";
            throw new IllegalStateException(String.format(message, this.getClass().getName()));
        }
        ParameterizedType superClass = (ParameterizedType)t;
        this.type = superClass.getActualTypeArguments()[0];
    }

    final Type getType() {
        return this.type;
    }

    public final String toString() {
        return this.type.toString();
    }
}

