/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.windup.decompiler.api.DecompilationFailure;

public class DecompilationResult {
    private final List<DecompilationFailure> failed = Collections.synchronizedList(new LinkedList());
    private final Map<String, String> decompiledFiles = Collections.synchronizedMap(new HashMap());

    public void addDecompiled(List<String> sourceClassPaths, String decompiledJavaPath) {
        String mainClassPath = null;
        for (String inputPath : sourceClassPaths) {
            if (inputPath.contains("$")) continue;
            mainClassPath = inputPath;
        }
        if (mainClassPath == null) {
            mainClassPath = sourceClassPaths.get(0);
        }
        this.decompiledFiles.put(mainClassPath, decompiledJavaPath);
    }

    public Map<String, String> getDecompiledFiles() {
        return this.decompiledFiles;
    }

    public void addFailure(DecompilationFailure failure) {
        this.failed.add(failure);
    }

    public List<DecompilationFailure> getFailures() {
        return Collections.unmodifiableList(this.failed);
    }
}

