/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.bootstrap;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.SerializerFactory;
import io.netty.bootstrap.AbstractBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ipfilter.IpFilterRuleHandler;
import io.netty.handler.ipfilter.IpFilterRuleList;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.rzo.netty.ahessian.auth.AuthToken;
import org.rzo.netty.ahessian.auth.AuthTokenList;
import org.rzo.netty.ahessian.auth.Base64AuthToken;
import org.rzo.netty.ahessian.auth.ClientAuthFilter;
import org.rzo.netty.ahessian.auth.EncryptedAuthToken;
import org.rzo.netty.ahessian.auth.ServerAuthFilter;
import org.rzo.netty.ahessian.auth.SimpleAuthToken;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactory;
import org.rzo.netty.ahessian.bootstrap.ChannelPipelineFactoryFactory;
import org.rzo.netty.ahessian.crypto.ClientCryptoData;
import org.rzo.netty.ahessian.crypto.ClientCryptoFilterInbound;
import org.rzo.netty.ahessian.crypto.ClientCryptoFilterOutbound;
import org.rzo.netty.ahessian.crypto.ServerCryptoData;
import org.rzo.netty.ahessian.crypto.ServerCryptoFilterInbound;
import org.rzo.netty.ahessian.heartbeat.ClientHeartbeatHandlerOutbound;
import org.rzo.netty.ahessian.heartbeat.HeartbeatHandlerInbound;
import org.rzo.netty.ahessian.heartbeat.ServerHeartbeatHandler;
import org.rzo.netty.ahessian.heartbeat.TimedOutAction;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.io.OutputStreamHandler;
import org.rzo.netty.ahessian.io.PullInputStreamConsumer;
import org.rzo.netty.ahessian.rpc.client.BootstrapProvider;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.ahessian.rpc.client.ReconnectHandler;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallDecoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallEncoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyDecoder;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyEncoder;
import org.rzo.netty.ahessian.rpc.server.ExecutorInvokeService;
import org.rzo.netty.ahessian.rpc.server.HessianRPCServiceHandler;
import org.rzo.netty.ahessian.rpc.server.ImmediateInvokeService;
import org.rzo.netty.ahessian.session.ClientSessionFilter;
import org.rzo.netty.ahessian.session.ServerSessionFilter;
import org.rzo.netty.ahessian.stopable.StopHandler;

public class ChannelPipelineFactoryBuilder<T>
implements ChannelPipelineFactoryFactory {
    long _reconnectTimeout = -1L;
    private long _serverHeartbeatTimeout = -1L;
    private long _clientHeartbeatTimeout = -1L;
    private boolean _isClient = true;
    private long _sessionTimeout = -1L;
    private String[] _passwords = null;
    private Encryption _passwordEncryption = null;
    private Object _serverService = null;
    private Class _serverServiceInterface = null;
    private String _ipFilter = null;
    private boolean _unique = false;
    private boolean _immediateInvoke;
    private boolean _executorInvoke;
    private int _executorThreads;
    private Map _serviceOptions;
    private static Timer TIMER = new HashedWheelTimer();
    private boolean _ssl = false;
    protected HessianRPCServiceHandler _serverFactory;
    protected HessianProxyFactory _clientFactory;
    private boolean _debug = false;
    private Executor _executor = Executors.newCachedThreadPool();
    private T _proxy;
    private SerializerFactory _serializerFactory;
    private boolean _inverseServer = false;
    private HessianRPCServiceHandler.ConnectListener _connectedListener;
    private HessianRPCServiceHandler.ConnectListener _disconnectedListener;

    public ChannelPipelineFactoryBuilder reconnect(long timeout) {
        this._reconnectTimeout = timeout;
        return this;
    }

    public ChannelPipelineFactoryBuilder ssl() {
        throw new RuntimeException("not yet implemented");
    }

    public ChannelPipelineFactoryBuilder compression() {
        throw new RuntimeException("not yet implemented");
    }

    public ChannelPipelineFactoryBuilder connectedListener(HessianRPCServiceHandler.ConnectListener listener) {
        this._connectedListener = listener;
        return this;
    }

    public ChannelPipelineFactoryBuilder disconnectedListener(HessianRPCServiceHandler.ConnectListener listener) {
        this._disconnectedListener = listener;
        return this;
    }

    public ChannelPipelineFactoryBuilder serializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public ChannelPipelineFactoryBuilder inverseServer(boolean inverseServer) {
        this._inverseServer = inverseServer;
        return this;
    }

    public ChannelPipelineFactoryBuilder serverHeartbeat(long timeout) {
        this._serverHeartbeatTimeout = timeout;
        return this;
    }

    public ChannelPipelineFactoryBuilder clientHeartbeat(long timeout) {
        this._clientHeartbeatTimeout = timeout;
        return this;
    }

    public ChannelPipelineFactoryBuilder sessionTimeout(long timeout) {
        this._sessionTimeout = timeout;
        return this;
    }

    public ChannelPipelineFactoryBuilder password(String ... pwd) {
        this._passwords = pwd;
        return this;
    }

    public ChannelPipelineFactoryBuilder passwordEncryption(Encryption enc) {
        this._passwordEncryption = enc;
        return this;
    }

    public ChannelPipelineFactoryBuilder rpcServerService(T service) {
        this._serverService = service;
        return this;
    }

    public ChannelPipelineFactoryBuilder rpcServiceInterface(Class<T> interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new RuntimeException("expecting an interface: " + interfaceClass);
        }
        this._serverServiceInterface = interfaceClass;
        return this;
    }

    public ChannelPipelineFactoryBuilder ipFilter(String ipFilter) {
        this._ipFilter = ipFilter;
        return this;
    }

    public ChannelPipelineFactoryBuilder single() {
        this._unique = true;
        return this;
    }

    public ChannelPipelineFactoryBuilder serverSingleThreadService() {
        this._immediateInvoke = true;
        return this;
    }

    public ChannelPipelineFactoryBuilder serviceThreads(int threads) {
        this._executorInvoke = true;
        this._executorThreads = threads;
        return this;
    }

    public ChannelPipelineFactoryBuilder serviceOptions(Map options) {
        this._serviceOptions = options;
        return this;
    }

    public ChannelPipelineFactoryBuilder debug() {
        this._debug = true;
        return this;
    }

    @Override
    public ChannelPipelineFactory create(EventExecutorGroup group, AbstractBootstrap bootstrap) {
        if (this.isRPCServer() && this.isRPC() && this._serverFactory == null) {
            this._serverFactory = new HessianRPCServiceHandler(Executors.newCachedThreadPool(), this._serviceOptions, TIMER);
            this._serverFactory.setConnectListener(this._connectedListener);
            this._serverFactory.setDisconnectListener(this._disconnectedListener);
            if (this.isExecutorService()) {
                this._serverFactory.addService("default", new ExecutorInvokeService(this._serverService, this._serverServiceInterface, this._serverFactory, Executors.newFixedThreadPool(this._executorThreads)));
            } else {
                this._serverFactory.addService("default", new ImmediateInvokeService(this._serverService, this._serverServiceInterface, this._serverFactory));
            }
        } else if (this.isRPC() && this._clientFactory == null) {
            ExecutorService executor = this._executorThreads > 0 ? Executors.newFixedThreadPool(this._executorThreads) : Executors.newSingleThreadExecutor();
            String name = "NONAME?";
            this._clientFactory = new HessianProxyFactory(executor, name, this._serviceOptions);
        }
        ChannelPipelineFactory result = this.hasSession() ? this.basePipelineFactory(this.mixinPipelineFactory(group, bootstrap), group, bootstrap) : this.mergePipelineFactory(this.basePipelineFactory(group, bootstrap), this.mixinPipelineFactory(group, bootstrap));
        if (this._debug) {
            result.debug();
        }
        return result;
    }

    private boolean isExecutorService() {
        return this._executorInvoke;
    }

    private ChannelPipelineFactory mergePipelineFactory(final ChannelPipelineFactory basePipelineFactory, final ChannelPipelineFactory mixinPipelineFactory) {
        return new ChannelPipelineFactory(){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
                ChannelPipelineFactory.HandlerList basePipeline = basePipelineFactory.getPipeline();
                ChannelPipelineFactory.HandlerList mixinPipeline = mixinPipelineFactory.getPipeline();
                basePipeline.addAll(mixinPipeline);
                return basePipeline;
            }
        };
    }

    private ChannelPipelineFactory basePipelineFactory(EventExecutorGroup group, AbstractBootstrap bootstrap) {
        return this.basePipelineFactory(null, group, bootstrap);
    }

    private ChannelPipelineFactory basePipelineFactory(ChannelPipelineFactory mixinPipelineFactory, EventExecutorGroup group, final AbstractBootstrap bootstrap) {
        final ClientSessionFilter clientSessionFilter = mixinPipelineFactory != null ? new ClientSessionFilter(mixinPipelineFactory) : null;
        final ServerSessionFilter serverSessionFilter = mixinPipelineFactory != null ? new ServerSessionFilter(mixinPipelineFactory, TIMER, this._sessionTimeout) : null;
        ChannelPipelineFactory result = new ChannelPipelineFactory(group){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
                ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
                if (ChannelPipelineFactoryBuilder.this.isRPCServer()) {
                    TimedOutAction outboundHandeler;
                    HeartbeatHandlerInbound inboundHandeler;
                    if (ChannelPipelineFactoryBuilder.this.hasIpFilter()) {
                        IpFilterRuleList list = new IpFilterRuleList(ChannelPipelineFactoryBuilder.this._ipFilter);
                        IpFilterRuleHandler ipfilter = new IpFilterRuleHandler(list);
                        pipeline.addLast("ipfilter", (ChannelHandler)ipfilter);
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasCrypto()) {
                        ServerCryptoData data = new ServerCryptoData();
                        String[] cryptoFilterInbound = new ServerCryptoFilterInbound(data);
                        ServerCryptoFilterInbound cryptoFilterOutbound = new ServerCryptoFilterInbound(data);
                        if (ChannelPipelineFactoryBuilder.this._passwords != null && ChannelPipelineFactoryBuilder.this._passwords.length > 0) {
                            for (String password : ChannelPipelineFactoryBuilder.this._passwords) {
                                cryptoFilterInbound.addPassword(password.getBytes());
                            }
                        }
                        pipeline.addLast("cryptoFilterIn", (ChannelHandler)cryptoFilterInbound);
                        pipeline.addLast("cryptoFilterOut", (ChannelHandler)cryptoFilterOutbound);
                    } else if (ChannelPipelineFactoryBuilder.this.hasAuthentication()) {
                        LinkedList<AuthToken> tokens = new LinkedList<AuthToken>();
                        for (String password : ChannelPipelineFactoryBuilder.this._passwords) {
                            SimpleAuthToken token = null;
                            if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.NONE)) {
                                token = new SimpleAuthToken();
                            } else if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.BASE64)) {
                                token = new Base64AuthToken("", ChannelPipelineFactoryBuilder.this._passwords[0]);
                            } else if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.MD5)) {
                                token = new EncryptedAuthToken();
                                ((EncryptedAuthToken)token).setAlgorithm("MD5");
                                ((EncryptedAuthToken)token).setPassword(ChannelPipelineFactoryBuilder.this._passwords[0]);
                                ((EncryptedAuthToken)token).setLength(20);
                            }
                            if (token == null) continue;
                            tokens.add(token);
                        }
                        AuthTokenList tokenList = AuthTokenList.fromList(tokens, ChannelPipelineFactoryBuilder.this._unique);
                        ServerAuthFilter filter = new ServerAuthFilter(tokenList);
                        pipeline.addLast("authentication", (ChannelHandler)filter);
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasServerHeartbeat()) {
                        inboundHandeler = new HeartbeatHandlerInbound("client_heartbeat", TIMER, ChannelPipelineFactoryBuilder.this._clientHeartbeatTimeout);
                        outboundHandeler = new ServerHeartbeatHandler(inboundHandeler);
                        pipeline.addLast("server_heartbeat_in", (ChannelHandler)inboundHandeler);
                        pipeline.addLast("server_heartbeat_out", (ChannelHandler)outboundHandeler);
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasClientHeartbeat()) {
                        inboundHandeler = new HeartbeatHandlerInbound("client_heartbeat", TIMER, ChannelPipelineFactoryBuilder.this._clientHeartbeatTimeout);
                        outboundHandeler = new ClientHeartbeatHandlerOutbound(inboundHandeler);
                        pipeline.addLast("client_heartbeat_in", (ChannelHandler)inboundHandeler);
                        pipeline.addLast("client_heartbeat_out", (ChannelHandler)outboundHandeler);
                    }
                    if (serverSessionFilter != null) {
                        pipeline.addLast("sessionFilter", (ChannelHandler)serverSessionFilter);
                    }
                } else {
                    TimedOutAction outboundHandeler;
                    HeartbeatHandlerInbound inboundHandeler;
                    if (ChannelPipelineFactoryBuilder.this.hasReconnect()) {
                        pipeline.addLast("reconnect", (ChannelHandler)new ReconnectHandler(new BootstrapProvider(){

                            @Override
                            public AbstractBootstrap getBootstrap() {
                                return bootstrap;
                            }
                        }, ChannelPipelineFactoryBuilder.this._reconnectTimeout, TIMER));
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasCrypto()) {
                        ClientCryptoData data = new ClientCryptoData();
                        ClientCryptoFilterInbound cryptoFilterIn = new ClientCryptoFilterInbound(data);
                        ClientCryptoFilterOutbound cryptoFilterOut = new ClientCryptoFilterOutbound(data);
                        if (ChannelPipelineFactoryBuilder.this._passwords != null && ChannelPipelineFactoryBuilder.this._passwords.length > 0) {
                            cryptoFilterIn.setPassword(ChannelPipelineFactoryBuilder.this._passwords[0].getBytes());
                        }
                        pipeline.addLast("cryptoFilterIn", (ChannelHandler)cryptoFilterIn);
                        pipeline.addLast("cryptoFilterOut", (ChannelHandler)cryptoFilterOut);
                    } else if (ChannelPipelineFactoryBuilder.this.hasAuthentication()) {
                        SimpleAuthToken token = null;
                        if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.NONE)) {
                            token = new SimpleAuthToken();
                        } else if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.BASE64)) {
                            token = new Base64AuthToken("", ChannelPipelineFactoryBuilder.this._passwords[0]);
                        } else if (ChannelPipelineFactoryBuilder.this._passwordEncryption.equals((Object)Encryption.MD5)) {
                            token = new EncryptedAuthToken();
                            ((EncryptedAuthToken)token).setAlgorithm("MD5");
                            ((EncryptedAuthToken)token).setPassword(ChannelPipelineFactoryBuilder.this._passwords[0]);
                            ((EncryptedAuthToken)token).setLength(20);
                        }
                        if (token != null) {
                            pipeline.addLast("authentication", (ChannelHandler)new ClientAuthFilter(token));
                        }
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasServerHeartbeat()) {
                        inboundHandeler = new HeartbeatHandlerInbound("client_heartbeat", TIMER, ChannelPipelineFactoryBuilder.this._clientHeartbeatTimeout);
                        outboundHandeler = new ServerHeartbeatHandler(inboundHandeler);
                        pipeline.addLast("server_heartbeat_in", (ChannelHandler)inboundHandeler);
                        pipeline.addLast("server_heartbeat_out", (ChannelHandler)outboundHandeler);
                    }
                    if (ChannelPipelineFactoryBuilder.this.hasClientHeartbeat()) {
                        inboundHandeler = new HeartbeatHandlerInbound("client_heartbeat", TIMER, ChannelPipelineFactoryBuilder.this._clientHeartbeatTimeout);
                        outboundHandeler = new ClientHeartbeatHandlerOutbound(inboundHandeler);
                        pipeline.addLast("client_heartbeat_in", (ChannelHandler)inboundHandeler);
                        pipeline.addLast("client_heartbeat_out", (ChannelHandler)outboundHandeler);
                    }
                    if (clientSessionFilter != null) {
                        pipeline.addLast("sessionFilter", (ChannelHandler)clientSessionFilter);
                    }
                }
                return pipeline;
            }
        };
        return result;
    }

    protected boolean hasServerHeartbeat() {
        return this._serverHeartbeatTimeout > 0L;
    }

    protected boolean hasClientHeartbeat() {
        return this._clientHeartbeatTimeout > 0L;
    }

    protected boolean hasCrypto() {
        return false;
    }

    protected boolean hasAuthentication() {
        return this._passwords != null && this._passwords.length > 0 && this._passwordEncryption != null;
    }

    protected boolean hasReconnect() {
        return this._reconnectTimeout > 0L;
    }

    protected boolean hasIpFilter() {
        return this._ipFilter != null && this._ipFilter.length() != 0;
    }

    private ChannelPipelineFactory mixinPipelineFactory(EventExecutorGroup group, AbstractBootstrap bootstrap) {
        ChannelPipelineFactory result = new ChannelPipelineFactory(group){

            @Override
            public ChannelPipelineFactory.HandlerList getPipeline() throws Exception {
                ChannelPipelineFactory.HandlerList pipeline = new ChannelPipelineFactory.HandlerList();
                if (ChannelPipelineFactoryBuilder.this.isRPC()) {
                    if (ChannelPipelineFactoryBuilder.this.isRPCServer()) {
                        pipeline.addLast("inputStream", new InputStreamHandler());
                        pipeline.addLast("outputStream", new OutputStreamHandler(), this.getGroup());
                        pipeline.addLast("callDecoder", new PullInputStreamConsumer(new HessianRPCCallDecoder((AbstractSerializerFactory)ChannelPipelineFactoryBuilder.this._serializerFactory)), this.getGroup());
                        pipeline.addLast("replyEncoder", new HessianRPCReplyEncoder((AbstractSerializerFactory)ChannelPipelineFactoryBuilder.this._serializerFactory, ChannelPipelineFactoryBuilder.this._executor), this.getGroup());
                        pipeline.addLast("hessianRPCServer", (ChannelHandler)ChannelPipelineFactoryBuilder.this._serverFactory, this.getGroup());
                        pipeline.addLast("stop", (ChannelHandler)new StopHandler(), this.getGroup());
                    } else {
                        ChannelPipelineFactoryBuilder.this._clientFactory.setConnectedListener(ChannelPipelineFactoryBuilder.this._connectedListener);
                        ChannelPipelineFactoryBuilder.this._clientFactory.setDisconnectedListener(ChannelPipelineFactoryBuilder.this._disconnectedListener);
                        pipeline.addLast("inputStream", new InputStreamHandler());
                        pipeline.addLast("outputStream", new OutputStreamHandler(), this.getGroup());
                        pipeline.addLast("replyDecoder", new PullInputStreamConsumer(new HessianRPCReplyDecoder(ChannelPipelineFactoryBuilder.this._clientFactory, (AbstractSerializerFactory)ChannelPipelineFactoryBuilder.this._serializerFactory)), this.getGroup());
                        pipeline.addLast("callEncoder", new HessianRPCCallEncoder(ChannelPipelineFactoryBuilder.this._inverseServer, (AbstractSerializerFactory)ChannelPipelineFactoryBuilder.this._serializerFactory, ChannelPipelineFactoryBuilder.this._executor), this.getGroup());
                        pipeline.addLast("hessianRPCClient", (ChannelHandler)ChannelPipelineFactoryBuilder.this._clientFactory, this.getGroup());
                        pipeline.addLast("stop", (ChannelHandler)new StopHandler(), this.getGroup());
                    }
                }
                return pipeline;
            }
        };
        return result;
    }

    private boolean hasSession() {
        return this._sessionTimeout > 0L;
    }

    private boolean isRPC() {
        return this._serverServiceInterface != null;
    }

    private boolean isRPCServer() {
        return this._serverService != null;
    }

    public HessianProxyFactory proxyFactory() {
        return this._clientFactory;
    }

    public T proxy() {
        if (this._proxy == null) {
            if (this._clientFactory == null) {
                throw new RuntimeException("client factory is null. Note: proxy() can only invoked on clients");
            }
            this._proxy = this._clientFactory.create(this._serverServiceInterface, this.getClass().getClassLoader(), this._serviceOptions);
        }
        return this._proxy;
    }

    public void close() {
        if (this._clientFactory == null) {
            return;
        }
        this._clientFactory.setBlocked(true);
        this._clientFactory.invalidateAllPendingCalls();
        this._clientFactory.invalidateProxies();
        this._proxy = null;
    }

    public void unblock() {
        if (this._clientFactory == null) {
            return;
        }
        this._clientFactory.setBlocked(false);
    }

    static enum Encryption {
        MD5,
        BASE64,
        NONE;

    }
}

