/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.crypto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.Cipher;
import org.rzo.netty.ahessian.crypto.CryptoConstants;
import org.rzo.netty.ahessian.crypto.ServerCryptoData;
import org.rzo.netty.ahessian.crypto.StreamCipher;
import org.rzo.netty.ahessian.crypto.StreamCipherFactory;
import org.rzo.netty.ahessian.crypto.Util;
import org.rzo.netty.ahessian.log.OutLogger;

public class ServerCryptoFilterInbound
extends ChannelInboundHandlerAdapter
implements CryptoConstants {
    KeyPair _serverKeyPair;
    Key _clientKey;
    private StreamCipher _decodeCipher;
    private byte[] _cryptedIvKeyMessage;
    private int _bytesRead;
    private List<byte[]> _passwords = new ArrayList<byte[]>();
    ServerCryptoData _data;

    public ServerCryptoFilterInbound(ServerCryptoData data) {
        this._data = data;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.sendByteArray(ctx, this.getPublicKeyEncoded());
    }

    private void sendByteArray(ChannelHandlerContext ctx, byte[] buffer) {
        try {
            Channel channel = ctx.channel();
            ByteBuf b = Unpooled.buffer();
            b.writeInt(buffer.length);
            b.writeBytes(buffer);
            ctx.write((Object)b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    byte[] getPublicKeyEncoded() {
        try {
            SecureRandom random = new SecureRandom();
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(1024, random);
            this._serverKeyPair = generator.generateKeyPair();
            PublicKey pubKey = this._serverKeyPair.getPublic();
            return pubKey.getEncoded();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) throws Exception {
        if (this._decodeCipher != null) {
            ByteBuf m = Util.code(this._decodeCipher, (ByteBuf)e, true);
            ctx.fireChannelRead((Object)m);
        } else {
            ByteBuf b = (ByteBuf)e;
            if (this._cryptedIvKeyMessage == null) {
                int size = b.readInt();
                if (size > 1024) {
                    ctx.channel().close();
                    return;
                }
                this._cryptedIvKeyMessage = new byte[size];
            }
            int available = b.readableBytes();
            int toRead = Math.min(this._cryptedIvKeyMessage.length - this._bytesRead, available);
            b.readBytes(this._cryptedIvKeyMessage, this._bytesRead, toRead);
            this._bytesRead += toRead;
            if (this._bytesRead == this._cryptedIvKeyMessage.length) {
                boolean ok = false;
                try {
                    this.createCiphers();
                    ok = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ctx.channel().close();
                }
                if (ok) {
                    ctx.fireChannelActive();
                }
            }
        }
    }

    private void createCiphers() throws Exception {
        String type = "".equals("ECB/NOPADDING") ? "RSA" : "RSA/ECB/NOPADDING";
        Cipher asymCipher = Cipher.getInstance(type);
        asymCipher.init(2, this._serverKeyPair.getPrivate());
        byte[] data = asymCipher.doFinal(this._cryptedIvKeyMessage);
        System.out.println("received iv+key: " + OutLogger.asString(data));
        byte[] iv = new byte[8];
        System.arraycopy(data, data.length - 54, iv, 0, iv.length);
        System.out.println("received iv: " + OutLogger.asString(iv));
        byte[] key = new byte[16];
        System.arraycopy(data, data.length - 31, key, 0, key.length);
        System.out.println("received key: " + OutLogger.asString(key));
        byte[] password = new byte[15];
        System.arraycopy(data, data.length - 15, password, 0, password.length);
        if (!this.checkPassword(password)) {
            throw new RuntimeException("password mismatch");
        }
        this._data._encodeCipher = StreamCipherFactory.createCipher("RC4");
        this._data._encodeCipher.engineInitEncrypt(key, iv);
        this._decodeCipher = StreamCipherFactory.createCipher("RC4");
        this._decodeCipher.engineInitDecrypt(key, iv);
    }

    private boolean checkPassword(byte[] password) {
        if (password == null || password.length != 15) {
            return false;
        }
        for (byte[] pwd : this._passwords) {
            if (!Arrays.equals(password, pwd)) continue;
            return true;
        }
        return false;
    }

    public void addPassword(byte[] password) {
        if (password == null || password.length == 0) {
            return;
        }
        byte[] mPassword = new byte[15];
        Arrays.fill(mPassword, (byte)0);
        int length = Math.min(15, password.length);
        System.arraycopy(password, 0, mPassword, 0, length);
        this._passwords.add(mPassword);
    }

    public static void main(String[] args) {
        ServerCryptoFilterInbound h = new ServerCryptoFilterInbound(new ServerCryptoData());
        h.getPublicKeyEncoded();
    }
}

