/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.callback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.callback.Callback;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.callback.ServerCallbackProxy;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;

public class ClientCallback
implements Serializable {
    private transient Callback _callback;
    private Long _id;
    private String _callbackClass;
    private String[] _interfaces;
    private String[] _returnMethods;
    private static final AtomicLong _idCounter = new AtomicLong();
    private transient boolean _done = false;

    public ClientCallback() {
    }

    public ClientCallback(Callback callback) {
        this._callback = callback;
        this._id = _idCounter.getAndIncrement();
        this._callbackClass = this._callback.getClass().getName();
        this._interfaces = this.determineInterfaces(this._callback.getClass());
        this._returnMethods = this.determineReturnMethods(this._callback.getClass());
    }

    private String[] determineReturnMethods(Class<? extends Callback> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getReturnType().equals(Void.TYPE)) continue;
            methods.add(method);
        }
        String[] result = new String[methods.size()];
        int i = 0;
        for (Method method : methods) {
            result[i] = method.getName();
            ++i;
        }
        return result;
    }

    private String[] determineInterfaces(Class clazz) {
        ArrayList clazzes = new ArrayList();
        while (clazz != null && !clazz.equals(Object.class)) {
            clazzes.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        String[] result = new String[clazzes.size()];
        int i = 0;
        for (Class clazz2 : clazzes) {
            result[i] = clazz2.getName();
            ++i;
        }
        return result;
    }

    public Long getId() {
        return this._id;
    }

    public void invoke(CallbackReplyMessage message, ChannelHandlerContext ctx) {
        String methodName = message.getMethod();
        Object result = null;
        Exception fault = null;
        try {
            Method[] methods;
            Object[] args = message.getArgs();
            if (args == null) {
                args = new Object[]{};
            }
            for (Method method : methods = this._callback.getClass().getMethods()) {
                if (!methodName.equals(method.getName()) || method.getParameterTypes().length != args.length) continue;
                result = method.invoke((Object)this._callback, args);
                break;
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("error invoking " + methodName, (Throwable)ex);
            fault = ex;
        }
        this.handleCallbackResult(fault, result, message, ctx);
    }

    private void handleCallbackResult(Object fault, Object result, CallbackReplyMessage message, ChannelHandlerContext ctx) {
        HashMap<Object, Object> headers = new HashMap<Object, Object>();
        headers.put(9, message.getCallbackCallId());
        HessianRPCCallMessage call = new HessianRPCCallMessage(message.getCallbackMethod(), new Object[]{fault, result}, headers, null);
        this.writeResult(call, ctx.channel());
    }

    private void writeResult(HessianRPCCallMessage reply, Channel channel) {
        channel.write((Object)reply);
    }

    public String getCallbackClass() {
        return this._callbackClass;
    }

    public String[] getInterfaces() {
        return this._interfaces;
    }

    public static Object clientCallbackArgProxy(ClientCallback cc, ServerCallbackProxy serverCallbackProxy) throws Exception {
        ClassLoader cl = cc.getClass().getClassLoader();
        ArrayList clazzes = new ArrayList();
        for (String clz : cc.getInterfaces()) {
            try {
                clazzes.add(cl.loadClass(clz));
            }
            catch (Exception ex) {
                System.out.println("error loading: " + clz);
            }
        }
        if (!clazzes.contains(Callback.class)) {
            clazzes.add(Callback.class);
        }
        return Proxy.newProxyInstance(cl, clazzes.toArray(new Class[clazzes.size()]), (InvocationHandler)serverCallbackProxy);
    }

    public String[] getReturnMethods() {
        return this._returnMethods;
    }
}

