/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class UnsignedNumeric {
    public static int readUnsignedInt(DataInput in) throws IOException {
        byte b = in.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static int readUnsignedInt(InputStream in) throws IOException {
        int b = in.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.read();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static int readUnsignedInt(ByteBuffer in) {
        byte b = in.get();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.get();
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedInt(DataOutput out, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static void writeUnsignedInt(OutputStream out, int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            out.write((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.write((byte)i);
    }

    public static byte sizeUnsignedInt(int i) {
        byte size = 1;
        while ((i & 0xFFFFFF80) != 0) {
            size = (byte)(size + 1);
            i >>>= 7;
        }
        return size;
    }

    public static void writeUnsignedInt(ByteBuffer out, int i) {
        while ((i & 0xFFFFFF80) != 0) {
            out.put((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        out.put((byte)i);
    }

    public static long readUnsignedLong(DataInput in) throws IOException {
        byte b = in.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static long readUnsignedLong(InputStream in) throws IOException {
        int b = in.read();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.read();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static long readUnsignedLong(ByteBuffer in) {
        byte b = in.get();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = in.get();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedLong(DataOutput out, long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.writeByte((byte)i);
    }

    public static void writeUnsignedLong(OutputStream out, long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.write((byte)i);
    }

    public static void writeUnsignedLong(ByteBuffer out, long i) {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.put((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        out.put((byte)i);
    }

    public static int readUnsignedInt(byte[] bytes, int offset) {
        byte b = bytes[offset++];
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = bytes[offset++];
            i = (int)((long)i | ((long)b & 0x7FL) << shift);
            shift += 7;
        }
        return i;
    }

    public static int writeUnsignedInt(byte[] bytes, int offset, int i) {
        int localOffset = offset;
        while ((i & 0xFFFFFF80) != 0) {
            bytes[localOffset++] = (byte)(i & 0x7F | 0x80);
            i >>>= 7;
        }
        bytes[localOffset++] = (byte)i;
        return localOffset - offset;
    }

    public static long readUnsignedLong(byte[] bytes, int offset) {
        byte b = bytes[offset++];
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = bytes[offset++];
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    public static void writeUnsignedLong(byte[] bytes, int offset, long i) {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            bytes[offset++] = (byte)(i & 0x7FL | 0x80L);
            i >>>= 7;
        }
        bytes[offset] = (byte)i;
    }
}

