/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.tx;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.UUID;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;

public abstract class TransactionManagerImpl
implements TransactionManager {
    private static final Log log = LogFactory.getLog(TransactionManagerImpl.class);
    private static final ThreadLocal<Transaction> CURRENT_TRANSACTION = new ThreadLocal();
    protected final UUID transactionManagerId = Util.threadLocalRandomUUID();

    public static void dissociateTransaction() {
        CURRENT_TRANSACTION.remove();
    }

    static void associateTransaction(Transaction tx) {
        CURRENT_TRANSACTION.set(tx);
    }

    public Transaction getTransaction() {
        return CURRENT_TRANSACTION.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTx = this.getTransaction();
        if (currentTx != null) {
            throw new NotSupportedException(String.valueOf(Thread.currentThread()) + " is already associated with a transaction (" + String.valueOf(currentTx) + ")");
        }
        TransactionManagerImpl.associateTransaction(this.createTransaction());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        try {
            this.getTransactionAndFailIfNone().commit();
        }
        finally {
            TransactionManagerImpl.dissociateTransaction();
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        try {
            this.getTransactionAndFailIfNone().rollback();
        }
        finally {
            TransactionManagerImpl.dissociateTransaction();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionAndFailIfNone().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        throw new SystemException("not supported");
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        TransactionManagerImpl.dissociateTransaction();
        if (log.isTraceEnabled()) {
            log.tracef("Suspending tx %s", tx);
        }
        return tx;
    }

    public void resume(Transaction tx) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (log.isTraceEnabled()) {
            log.tracef("Resuming tx %s", tx);
        }
        TransactionManagerImpl.associateTransaction(tx);
    }

    protected abstract Transaction createTransaction();

    private Transaction getTransactionAndFailIfNone() {
        Transaction transaction = CURRENT_TRANSACTION.get();
        if (transaction == null) {
            throw new IllegalStateException("no transaction associated with calling thread");
        }
        return transaction;
    }
}

