/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.xfer.scp;

import java.io.IOException;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.xfer.AbstractFileTransfer;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.FileTransfer;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.scp.SCPDownloadClient;
import net.schmizz.sshj.xfer.scp.SCPEngine;
import net.schmizz.sshj.xfer.scp.SCPException;
import net.schmizz.sshj.xfer.scp.SCPUploadClient;

public class SCPFileTransfer
extends AbstractFileTransfer
implements FileTransfer {
    private static final int DEFAULT_BANDWIDTH_LIMIT = -1;
    private final SessionFactory sessionFactory;
    private int bandwidthLimit;

    public SCPFileTransfer(SessionFactory sessionFactory, LoggerFactory loggerFactory) {
        super(loggerFactory);
        this.sessionFactory = sessionFactory;
        this.bandwidthLimit = -1;
    }

    public SCPDownloadClient newSCPDownloadClient() {
        return new SCPDownloadClient(this.newSCPEngine(), this.bandwidthLimit);
    }

    public SCPUploadClient newSCPUploadClient() {
        return new SCPUploadClient(this.newSCPEngine(), this.bandwidthLimit);
    }

    private SCPEngine newSCPEngine() {
        return new SCPEngine(this.sessionFactory, this.getTransferListener(), this.loggerFactory);
    }

    @Override
    public void upload(String localPath, String remotePath) throws IOException {
        this.upload(localPath, remotePath, 0L);
    }

    @Override
    public void upload(String localFile, String remotePath, long byteOffset) throws IOException {
        this.upload(new FileSystemFile(localFile), remotePath, byteOffset);
    }

    @Override
    public void download(String remotePath, String localPath) throws IOException {
        this.download(remotePath, localPath, 0L);
    }

    @Override
    public void download(String remotePath, String localPath, long byteOffset) throws IOException {
        this.download(remotePath, new FileSystemFile(localPath), byteOffset);
    }

    @Override
    public void download(String remotePath, LocalDestFile localFile) throws IOException {
        this.download(remotePath, localFile, 0L);
    }

    @Override
    public void download(String remotePath, LocalDestFile localFile, long byteOffset) throws IOException {
        this.checkByteOffsetSupport(byteOffset);
        this.newSCPDownloadClient().copy(remotePath, localFile);
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath) throws IOException {
        this.upload(localFile, remotePath, 0L);
    }

    @Override
    public void upload(LocalSourceFile localFile, String remotePath, long byteOffset) throws IOException {
        this.checkByteOffsetSupport(byteOffset);
        this.newSCPUploadClient().copy(localFile, remotePath);
    }

    public SCPFileTransfer bandwidthLimit(int limit) {
        if (limit > 0) {
            this.bandwidthLimit = limit;
        }
        return this;
    }

    private void checkByteOffsetSupport(long byteOffset) throws IOException {
        if (byteOffset > 0L) {
            throw new SCPException("Byte offset on SCP file transfers is not supported.");
        }
    }
}

