/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata.reader;

import jakarta.persistence.JoinColumn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.hibernate.envers.AuditJoinTable;
import org.hibernate.envers.configuration.internal.metadata.ColumnNameIterator;

public class AuditJoinTableData {
    private final String name;
    private final String catalog;
    private final String schema;
    private final List<String> inverseJoinColumnNames = new ArrayList<String>(0);

    public AuditJoinTableData() {
        this.name = "";
        this.catalog = "";
        this.schema = "";
    }

    public AuditJoinTableData(AuditJoinTable auditJoinTable) {
        this.name = auditJoinTable.name();
        this.catalog = auditJoinTable.catalog();
        this.schema = auditJoinTable.schema();
        for (JoinColumn joinColumn : auditJoinTable.inverseJoinColumns()) {
            this.inverseJoinColumnNames.add(joinColumn.name());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public Collection<String> getInverseJoinColumnNames() {
        return Collections.unmodifiableCollection(this.inverseJoinColumnNames);
    }

    public ColumnNameIterator getInverseJoinColumnNamesIterator() {
        final Iterator<String> iterator = this.inverseJoinColumnNames.iterator();
        return new ColumnNameIterator(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public String next() {
                return (String)iterator.next();
            }
        };
    }
}

