/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;

public class EntityTypeAuditExpression
implements AuditCriterion {
    private String alias;
    private String entityName;

    public EntityTypeAuditExpression(String alias, String entityName) {
        this.alias = alias;
        this.entityName = entityName;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor auditReader, Map<String, String> aliasToEntityNameMap, Map<String, String> aliasToComponentPropertyNameMap, String baseAlias, QueryBuilder qb, Parameters parameters) {
        String effectiveAlias = this.alias == null ? baseAlias : this.alias;
        String effectiveEntityName = this.entityName;
        if (enversService.getEntitiesConfigurations().isVersioned(effectiveEntityName)) {
            effectiveEntityName = enversService.getConfig().getAuditEntityName(effectiveEntityName);
        }
        parameters.addEntityTypeRestriction(effectiveAlias, effectiveEntityName);
    }
}

