/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.ControllerHandler;
import org.rzo.yajsw.controller.jvm.JVMController;
import org.rzo.yajsw.controller.jvm.MessageDecoder;
import org.rzo.yajsw.controller.jvm.MessageEncoder;
import org.rzo.yajsw.nettyutils.ChannelGroupFilter;
import org.rzo.yajsw.nettyutils.Condition;
import org.rzo.yajsw.nettyutils.ConditionFilter;
import org.rzo.yajsw.nettyutils.LoggingFilter;
import org.rzo.yajsw.nettyutils.WhitelistFilter;

class ControllerPipelineFactory
extends ChannelInitializer<SocketChannel> {
    JVMController _controller;
    boolean _debug = false;

    ControllerPipelineFactory(JVMController controller) {
        this._controller = controller;
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        InetAddress currentAddress;
        ChannelPipeline pipeline = ch.pipeline();
        if (this._debug) {
            pipeline.addLast("logging1", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
        }
        pipeline.addLast("checkWaiting", (ChannelHandler)new ConditionFilter(new Condition(){

            @Override
            public boolean isOk(ChannelHandlerContext ctx, Object msg) {
                boolean result = true;
                int currentState = ControllerPipelineFactory.this._controller.getState();
                if (currentState == 3) {
                    ControllerPipelineFactory.this._controller.getLog().info("app already logged on -> rejecting new connection");
                    result = false;
                } else if (currentState == 8) {
                    if (ControllerPipelineFactory.this._debug) {
                        ControllerPipelineFactory.this._controller.getLog().info("app not running -> rejecting new connection");
                    }
                    result = false;
                }
                return result;
            }
        }));
        WhitelistFilter firewall = new WhitelistFilter();
        boolean ipAdded = false;
        try {
            InetAddress[] allIpsForCanonicalHostName;
            InetAddress localhost = InetAddress.getLocalHost();
            firewall.allow(localhost);
            ipAdded = true;
            if (this._debug) {
                this._controller.getLog().info("Added localhost IP addr: " + localhost + " - " + localhost.getHostAddress());
            }
            if ((allIpsForCanonicalHostName = InetAddress.getAllByName(localhost.getCanonicalHostName())) != null && allIpsForCanonicalHostName.length > 1) {
                if (this._debug) {
                    this._controller.getLog().info("Found multiple network internet addresses for canonical host name:");
                }
                for (int i = 0; i < allIpsForCanonicalHostName.length; ++i) {
                    currentAddress = allIpsForCanonicalHostName[i];
                    if (this._debug) {
                        this._controller.getLog().info("   Added InetAddress " + currentAddress);
                    }
                    firewall.allow(currentAddress);
                    ipAdded = true;
                }
            }
        }
        catch (UnknownHostException e) {
            this._controller.getLog().throwing(JVMController.class.getName(), "start", e);
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface currentInterface = en.nextElement();
                if (this._debug) {
                    this._controller.getLog().info("Adding local IPs for interface " + currentInterface.getName() + " - " + currentInterface.getDisplayName());
                }
                Enumeration<InetAddress> enumIpAddr = currentInterface.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    currentAddress = enumIpAddr.nextElement();
                    if (this._debug) {
                        this._controller.getLog().info("   Added InetAddress " + currentAddress.toString());
                    }
                    firewall.allow(currentAddress);
                    ipAdded = true;
                }
            }
        }
        catch (SocketException e) {
            this._controller.getLog().throwing(JVMController.class.getName(), "start", e);
        }
        if (!ipAdded) {
            this._controller.getLog().info("No IP added to whitelist. Defaulting to allow 127.0.0.1 and 127.0.1.1 .");
            byte[] addressBytes = new byte[]{127, 0, 0, 1};
            firewall.allow(InetAddress.getByAddress("localhost", addressBytes));
            addressBytes = new byte[]{127, 0, 1, 1};
            firewall.allow(InetAddress.getByAddress("localhost", addressBytes));
        }
        pipeline.addLast("firewall", (ChannelHandler)firewall);
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, true, Delimiters.nulDelimiter()));
        pipeline.addLast("messageEncoder", (ChannelHandler)new MessageEncoder());
        pipeline.addLast("messageDecoder", (ChannelHandler)new MessageDecoder());
        if (this._debug) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingFilter(this._controller.getLog(), "controller"));
            this._controller.getLog().info("jvm controller: netty logger set");
        }
        pipeline.addLast("removeConnected", (ChannelHandler)new ChannelGroupFilter(new Condition(){

            @Override
            public boolean isOk(ChannelHandlerContext ctx, Object msg) {
                boolean result = false;
                if (msg instanceof Message) {
                    Message m = (Message)msg;
                    result = m.getCode() == 116;
                }
                return result;
            }
        }));
        pipeline.addLast("handler", (ChannelHandler)new ControllerHandler(this._controller));
    }
}

