/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.updater;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.updater.InstallAction;
import org.rzo.yajsw.util.VFSUtils;
import org.rzo.yajsw.wrapper.WrappedService;

public class UpdaterMain {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("missing update or current configuration -> abort");
            return;
        }
        System.setProperty("wrapper.config", args[0]);
        YajswConfigurationImpl updateConfig = new YajswConfigurationImpl();
        System.setProperty("wrapper.config", args[1]);
        YajswConfigurationImpl currentAppConfig = new YajswConfigurationImpl();
        UpdaterMain.uninstallService(args[1]);
        String wrapperHome = UpdaterMain.updateWrapper(updateConfig);
        InstallAction.setCurrentConfig(currentAppConfig);
        InstallAction.setNewConfig(updateConfig.getString("update.app.config"));
        InstallAction.setWrapperHome(wrapperHome);
        InstallAction.run();
    }

    private static void uninstallService(String currentConfig) {
        WrappedService service = new WrappedService();
        ArrayList<String> list = new ArrayList<String>();
        list.add(currentConfig);
        service.init();
        service.stop();
        service.uninstall();
    }

    private static String updateWrapper(YajswConfigurationImpl updateConfig) throws Exception {
        String wrapperSrcFile = updateConfig.getString("update.wrapper.src", null);
        String wrapperDestFile = updateConfig.getString("update.wrapper.dest", null);
        if (wrapperSrcFile == null && wrapperDestFile == null) {
            return WrapperLoader.getWrapperHome();
        }
        if (wrapperSrcFile == null || wrapperDestFile == null) {
            System.out.println("wrapper src or destination is empty -> not updating wrapper");
            return WrapperLoader.getWrapperHome();
        }
        FileObject wrapperSrc = VFSUtils.resolveFile((String)null, wrapperSrcFile);
        FileObject wrapperDest = VFSUtils.resolveFile((String)null, wrapperDestFile);
        wrapperDest.copyFrom(wrapperSrc, new FileSelector(){

            public boolean includeFile(FileSelectInfo arg0) throws Exception {
                return true;
            }

            public boolean traverseDescendents(FileSelectInfo arg0) throws Exception {
                return true;
            }
        });
        return wrapperDest.getName().getPath();
    }
}

