/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.gcp;

import com.xebialabs.overthere.gcp.GenerateSshKey;
import com.xebialabs.overthere.gcp.SshKeyPair;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import org.bouncycastle.util.encoders.Base64;

class BouncycastleGenerateSshKey
implements GenerateSshKey {
    BouncycastleGenerateSshKey() {
    }

    @Override
    public SshKeyPair generate(String username, int keySize) {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(keySize);
            KeyPair key = keyGen.generateKeyPair();
            PrivateKey priv = key.getPrivate();
            PublicKey pub = key.getPublic();
            String privateKey = new String(Base64.encode((byte[])priv.getEncoded(), (int)0, (int)priv.getEncoded().length));
            String publicKey1 = new String(Base64.encode((byte[])pub.getEncoded(), (int)0, (int)pub.getEncoded().length));
            String publicKey = new String(Base64.encode((byte[])publicKey1.getBytes(), (int)0, (int)publicKey1.getBytes().length));
            RSAKeyPairGenerator rsaKeyPairGenerator = new RSAKeyPairGenerator();
            rsaKeyPairGenerator.init((KeyGenerationParameters)new RSAKeyGenerationParameters(BigInteger.valueOf(65537L), CryptoServicesRegistrar.getSecureRandom(), keySize, PrimeCertaintyCalculator.getDefaultCertainty((int)keySize)));
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = rsaKeyPairGenerator.generateKeyPair();
            PrivateKeyInfo pkInfo = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricCipherKeyPair.getPrivate());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo((AsymmetricKeyParameter)asymmetricCipherKeyPair.getPublic());
            return new SshKeyPair(username, privateKey, publicKey, "");
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

