/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonLongImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonPatchImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonStringImpl;
import org.apache.activemq.artemis.commons.shaded.json.JsonArray;
import org.apache.activemq.artemis.commons.shaded.json.JsonObject;
import org.apache.activemq.artemis.commons.shaded.json.JsonPatch;
import org.apache.activemq.artemis.commons.shaded.json.JsonPatchBuilder;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;
import org.apache.activemq.artemis.commons.shaded.json.spi.JsonProvider;

class JsonPatchBuilderImpl
implements JsonPatchBuilder {
    private final JsonProvider provider;
    private final List<JsonPatchImpl.PatchValue> operations;

    JsonPatchBuilderImpl(JsonProvider provider) {
        this.provider = provider;
        this.operations = new ArrayList<JsonPatchImpl.PatchValue>();
    }

    JsonPatchBuilderImpl(JsonProvider provider, JsonArray initialData) {
        this.provider = provider;
        this.operations = new ArrayList<JsonPatchImpl.PatchValue>(initialData.size());
        for (JsonValue value : initialData) {
            JsonObject operation = (JsonObject)value;
            JsonPatch.Operation op = JsonPatch.Operation.fromOperationName(operation.getString("op"));
            String path = operation.getString("path");
            String from = operation.getString("from", null);
            JsonValue jsonValue = (JsonValue)operation.get("value");
            this.operations.add(new JsonPatchImpl.PatchValue(provider, op, path, from, jsonValue));
        }
    }

    @Override
    public JsonPatchBuilder add(String path, JsonValue value) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.ADD, path, null, value));
    }

    @Override
    public JsonPatchBuilder add(String path, String value) {
        return this.add(path, JsonPatchBuilderImpl.toJsonString(value));
    }

    @Override
    public JsonPatchBuilder add(String path, int value) {
        return this.add(path, JsonPatchBuilderImpl.toJsonNumber(value));
    }

    @Override
    public JsonPatchBuilder add(String path, boolean value) {
        return this.add(path, JsonPatchBuilderImpl.toJsonBoolean(value));
    }

    @Override
    public JsonPatchBuilder remove(String path) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.REMOVE, path, null, null));
    }

    @Override
    public JsonPatchBuilder replace(String path, JsonValue value) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.REPLACE, path, null, value));
    }

    @Override
    public JsonPatchBuilder replace(String path, String value) {
        return this.replace(path, JsonPatchBuilderImpl.toJsonString(value));
    }

    @Override
    public JsonPatchBuilder replace(String path, int value) {
        return this.replace(path, JsonPatchBuilderImpl.toJsonNumber(value));
    }

    @Override
    public JsonPatchBuilder replace(String path, boolean value) {
        return this.replace(path, JsonPatchBuilderImpl.toJsonBoolean(value));
    }

    @Override
    public JsonPatchBuilder move(String path, String from) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.MOVE, path, from, null));
    }

    @Override
    public JsonPatchBuilder copy(String path, String from) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.COPY, path, from, null));
    }

    @Override
    public JsonPatchBuilder test(String path, JsonValue value) {
        return this.addOperation(new JsonPatchImpl.PatchValue(this.provider, JsonPatch.Operation.TEST, path, null, value));
    }

    @Override
    public JsonPatchBuilder test(String path, String value) {
        return this.test(path, JsonPatchBuilderImpl.toJsonString(value));
    }

    @Override
    public JsonPatchBuilder test(String path, int value) {
        return this.test(path, JsonPatchBuilderImpl.toJsonNumber(value));
    }

    @Override
    public JsonPatchBuilder test(String path, boolean value) {
        return this.test(path, JsonPatchBuilderImpl.toJsonBoolean(value));
    }

    @Override
    public JsonPatch build() {
        return new JsonPatchImpl(this.provider, new ArrayList<JsonPatchImpl.PatchValue>(this.operations));
    }

    private JsonPatchBuilder addOperation(JsonPatchImpl.PatchValue operation) {
        this.operations.add(operation);
        return this;
    }

    private static JsonValue toJsonBoolean(boolean value) {
        return value ? JsonValue.TRUE : JsonValue.FALSE;
    }

    private static JsonValue toJsonString(String value) {
        return value == null ? JsonValue.NULL : new JsonStringImpl(value);
    }

    private static JsonValue toJsonNumber(int value) {
        return new JsonLongImpl(value);
    }
}

