/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.convert.QueryByExamplePredicateBuilder;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.KeysetScrollSpecification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.DefaultQueryHints;
import org.springframework.data.jpa.repository.support.FetchableFluentQueryBySpecification;
import org.springframework.data.jpa.repository.support.FluentQuerySupport;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.data.jpa.repository.support.QueryHints;
import org.springframework.data.jpa.support.PageableUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.ProxyUtils;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID>
implements JpaRepositoryImplementation<T, ID> {
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null";
    private static final String IDS_MUST_NOT_BE_NULL = "Ids must not be null";
    private static final String ENTITY_MUST_NOT_BE_NULL = "Entity must not be null";
    private static final String ENTITIES_MUST_NOT_BE_NULL = "Entities must not be null";
    private static final String EXAMPLE_MUST_NOT_BE_NULL = "Example must not be null";
    private static final String SPECIFICATION_MUST_NOT_BE_NULL = "Specification must not be null";
    private static final String QUERY_FUNCTION_MUST_NOT_BE_NULL = "Query function must not be null";
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager entityManager;
    private final PersistenceProvider provider;
    @Nullable
    private CrudMethodMetadata metadata;
    @Nullable
    private ProjectionFactory projectionFactory;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation, (String)"JpaEntityInformation must not be null");
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null");
        this.entityInformation = entityInformation;
        this.entityManager = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager entityManager) {
        this(JpaEntityInformationSupport.getEntityInformation(domainClass, entityManager), entityManager);
    }

    @Override
    public void setRepositoryMethodMetadata(CrudMethodMetadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    @Override
    public void setProjectionFactory(ProjectionFactory projectionFactory) {
        this.projectionFactory = projectionFactory;
    }

    @Nullable
    protected CrudMethodMetadata getRepositoryMethodMetadata() {
        return this.metadata;
    }

    protected Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Transactional
    public void deleteById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        this.findById(id).ifPresent(this::delete);
    }

    @Transactional
    public void delete(T entity) {
        Assert.notNull(entity, (String)ENTITY_MUST_NOT_BE_NULL);
        if (this.entityInformation.isNew(entity)) {
            return;
        }
        if (this.entityManager.contains(entity)) {
            this.entityManager.remove(entity);
            return;
        }
        Class type = ProxyUtils.getUserClass(entity);
        Object existing = this.entityManager.find(type, this.entityInformation.getId(entity));
        if (existing != null) {
            this.entityManager.remove(this.entityManager.merge(entity));
        }
    }

    @Transactional
    public void deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)IDS_MUST_NOT_BE_NULL);
        for (ID id : ids) {
            this.deleteById(id);
        }
    }

    @Override
    @Transactional
    public void deleteAllByIdInBatch(Iterable<ID> ids) {
        Assert.notNull(ids, (String)IDS_MUST_NOT_BE_NULL);
        if (!ids.iterator().hasNext()) {
            return;
        }
        if (this.entityInformation.hasCompositeId()) {
            ArrayList entities = new ArrayList();
            ids.forEach(id -> {
                boolean bl = entities.add(this.getReferenceById(id));
            });
            this.deleteAllInBatch(entities);
        } else {
            String queryString = String.format("delete from %s x where %s in :ids", this.entityInformation.getEntityName(), this.entityInformation.getIdAttribute().getName());
            Query query = this.entityManager.createQuery(queryString);
            Collection<ID> idCollection = SimpleJpaRepository.toCollection(ids);
            query.setParameter("ids", idCollection);
            this.applyQueryHints(query);
            query.executeUpdate();
        }
    }

    @Transactional
    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)ENTITIES_MUST_NOT_BE_NULL);
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch(Iterable<T> entities) {
        Assert.notNull(entities, (String)ENTITIES_MUST_NOT_BE_NULL);
        if (!entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.entityManager).executeUpdate();
    }

    @Transactional
    public void deleteAll() {
        for (Object element : this.findAll()) {
            this.delete(element);
        }
    }

    @Override
    @Transactional
    public void deleteAllInBatch() {
        Query query = this.entityManager.createQuery(this.getDeleteAllQueryString());
        this.applyQueryHints(query);
        query.executeUpdate();
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        Class<T> domainType = this.getDomainClass();
        if (this.metadata == null) {
            return Optional.ofNullable(this.entityManager.find(domainType, id));
        }
        LockModeType type = this.metadata.getLockModeType();
        Map<String, Object> hints = this.getHints();
        return Optional.ofNullable(type == null ? this.entityManager.find(domainType, id, hints) : this.entityManager.find(domainType, id, type, hints));
    }

    @Override
    @Deprecated
    public T getOne(ID id) {
        return this.getReferenceById(id);
    }

    @Override
    @Deprecated
    public T getById(ID id) {
        return this.getReferenceById(id);
    }

    @Override
    public T getReferenceById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        return (T)this.entityManager.getReference(this.getDomainClass(), id);
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        if (this.entityInformation.getIdAttribute() == null) {
            return this.findById(id).isPresent();
        }
        String placeholder = this.provider.getCountQueryPlaceholder();
        String entityName = this.entityInformation.getEntityName();
        Collection<String> idAttributeNames = this.entityInformation.getIdAttributeNames();
        String existsQuery = QueryUtils.getExistsQueryString(entityName, placeholder, idAttributeNames);
        TypedQuery query = this.entityManager.createQuery(existsQuery, Long.class);
        this.applyQueryHints((Query)query);
        if (!this.entityInformation.hasCompositeId()) {
            query.setParameter((String)idAttributeNames.iterator().next(), id);
            return (Long)query.getSingleResult() == 1L;
        }
        for (String idAttributeName : idAttributeNames) {
            boolean complexIdParameterValueDiscovered;
            Object idAttributeValue = this.entityInformation.getCompositeIdAttributeValue(id, idAttributeName);
            boolean bl = complexIdParameterValueDiscovered = idAttributeValue != null && !query.getParameter(idAttributeName).getParameterType().isAssignableFrom(idAttributeValue.getClass());
            if (complexIdParameterValueDiscovered) {
                return this.findById(id).isPresent();
            }
            query.setParameter(idAttributeName, idAttributeValue);
        }
        return (Long)query.getSingleResult() == 1L;
    }

    public List<T> findAll() {
        return this.getQuery(null, Sort.unsorted()).getResultList();
    }

    public List<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)IDS_MUST_NOT_BE_NULL);
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (this.entityInformation.hasCompositeId()) {
            ArrayList results = new ArrayList();
            for (ID id : ids) {
                this.findById(id).ifPresent(results::add);
            }
            return results;
        }
        Collection<ID> idCollection = SimpleJpaRepository.toCollection(ids);
        ByIdsSpecification<T> specification = new ByIdsSpecification<T>(this.entityInformation);
        TypedQuery<T> query = this.getQuery(specification, Sort.unsorted());
        return query.setParameter(specification.parameter, idCollection).getResultList();
    }

    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    public Page<T> findAll(Pageable pageable) {
        return this.findAll((Specification<T>)null, pageable);
    }

    @Override
    public Optional<T> findOne(Specification<T> spec) {
        try {
            return Optional.of(this.getQuery(spec, Sort.unsorted()).setMaxResults(2).getSingleResult());
        }
        catch (NoResultException noResultException) {
            return Optional.empty();
        }
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.getQuery(spec, Sort.unsorted()).getResultList();
    }

    @Override
    public Page<T> findAll(@Nullable Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return pageable.isUnpaged() ? new Page<T>(query.getResultList()) : this.readPage(query, this.getDomainClass(), pageable, spec);
    }

    @Override
    public List<T> findAll(@Nullable Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    @Override
    public boolean exists(Specification<T> spec) {
        CriteriaQuery cq = this.entityManager.getCriteriaBuilder().createQuery(Integer.class).select((Selection)this.entityManager.getCriteriaBuilder().literal((Object)1));
        this.applySpecificationToCriteria(spec, this.getDomainClass(), cq);
        TypedQuery query = this.applyRepositoryMethodMetadata(this.entityManager.createQuery(cq));
        return query.setMaxResults(1).getResultList().size() == 1;
    }

    @Override
    @Transactional
    public long delete(@Nullable Specification<T> spec) {
        Predicate predicate;
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaDelete delete = builder.createCriteriaDelete(this.getDomainClass());
        if (spec != null && (predicate = spec.toPredicate(delete.from(this.getDomainClass()), builder.createQuery(this.getDomainClass()), builder)) != null) {
            delete.where((Expression)predicate);
        }
        return this.entityManager.createQuery(delete).executeUpdate();
    }

    @Override
    public <S extends T, R> R findBy(Specification<T> spec, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(spec, (String)SPECIFICATION_MUST_NOT_BE_NULL);
        Assert.notNull(queryFunction, (String)QUERY_FUNCTION_MUST_NOT_BE_NULL);
        return this.doFindBy(spec, this.getDomainClass(), queryFunction);
    }

    private <S extends T, R> R doFindBy(Specification<T> spec, Class<T> domainClass, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(spec, (String)SPECIFICATION_MUST_NOT_BE_NULL);
        Assert.notNull(queryFunction, (String)QUERY_FUNCTION_MUST_NOT_BE_NULL);
        FluentQuerySupport.ScrollQueryFactory scrollFunction = (sort, scrollPosition) -> {
            OffsetScrollPosition offset;
            Specification specToUse = spec;
            if (scrollPosition instanceof KeysetScrollPosition) {
                KeysetScrollPosition keyset = (KeysetScrollPosition)scrollPosition;
                KeysetScrollSpecification keysetSpec = new KeysetScrollSpecification(keyset, sort, this.entityInformation);
                sort = keysetSpec.sort();
                specToUse = specToUse.and(keysetSpec);
            }
            TypedQuery query = this.getQuery(specToUse, domainClass, sort);
            if (scrollPosition instanceof OffsetScrollPosition && !(offset = (OffsetScrollPosition)scrollPosition).isInitial()) {
                query.setFirstResult(Math.toIntExact(offset.getOffset()) + 1);
            }
            return query;
        };
        Function finder = sort -> this.getQuery((Specification)spec, (Class)domainClass, (Sort)sort);
        FetchableFluentQueryBySpecification.SpecificationScrollDelegate<T> scrollDelegate = new FetchableFluentQueryBySpecification.SpecificationScrollDelegate<T>(scrollFunction, this.entityInformation);
        FetchableFluentQueryBySpecification fluentQuery = new FetchableFluentQueryBySpecification(spec, domainClass, finder, scrollDelegate, this::count, this::exists, this.entityManager, this.getProjectionFactory());
        R result = queryFunction.apply(fluentQuery);
        if (result instanceof FluentQuery) {
            throw new InvalidDataAccessApiUsageException("findBy(\u2026) queries must result a query result and not the FluentQuery object to ensure that queries are executed within the scope of the findBy(\u2026) method");
        }
        return result;
    }

    @Override
    public <S extends T> Optional<S> findOne(Example<S> example) {
        try {
            return Optional.of(this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), Sort.unsorted()).setMaxResults(2).getSingleResult());
        }
        catch (NoResultException noResultException) {
            return Optional.empty();
        }
    }

    @Override
    public <S extends T> long count(Example<S> example) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType()));
    }

    @Override
    public <S extends T> boolean exists(Example<S> example) {
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example, this.escapeCharacter);
        CriteriaQuery cq = this.entityManager.getCriteriaBuilder().createQuery(Integer.class).select((Selection)this.entityManager.getCriteriaBuilder().literal((Object)1));
        this.applySpecificationToCriteria(spec, example.getProbeType(), cq);
        TypedQuery<S> query = this.applyRepositoryMethodMetadata(this.entityManager.createQuery(cq));
        return query.setMaxResults(1).getResultList().size() == 1;
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), Sort.unsorted()).getResultList();
    }

    @Override
    public <S extends T> List<S> findAll(Example<S> example, Sort sort) {
        return this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), example.getProbeType(), sort).getResultList();
    }

    @Override
    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example, this.escapeCharacter);
        Class probeType = example.getProbeType();
        TypedQuery<S> query = this.getQuery(new ExampleSpecification<S>(example, this.escapeCharacter), probeType, pageable);
        return pageable.isUnpaged() ? new Page<S>(query.getResultList()) : this.readPage(query, probeType, pageable, spec);
    }

    @Override
    public <S extends T, R> R findBy(Example<S> example, Function<FluentQuery.FetchableFluentQuery<S>, R> queryFunction) {
        Assert.notNull(example, (String)EXAMPLE_MUST_NOT_BE_NULL);
        Assert.notNull(queryFunction, (String)QUERY_FUNCTION_MUST_NOT_BE_NULL);
        ExampleSpecification<S> spec = new ExampleSpecification<S>(example, this.escapeCharacter);
        Class probeType = example.getProbeType();
        return this.doFindBy(spec, probeType, queryFunction);
    }

    public long count() {
        TypedQuery query = this.entityManager.createQuery(this.getCountQueryString(), Long.class);
        this.applyQueryHintsForCount((Query)query);
        return (Long)query.getSingleResult();
    }

    @Override
    public long count(@Nullable Specification<T> spec) {
        return SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec, this.getDomainClass()));
    }

    @Transactional
    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)ENTITY_MUST_NOT_BE_NULL);
        if (this.entityInformation.isNew(entity)) {
            this.entityManager.persist(entity);
            return entity;
        }
        return (S)this.entityManager.merge(entity);
    }

    @Override
    @Transactional
    public <S extends T> S saveAndFlush(S entity) {
        S result = this.save(entity);
        this.flush();
        return result;
    }

    @Transactional
    public <S extends T> List<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)ENTITIES_MUST_NOT_BE_NULL);
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public <S extends T> List<S> saveAllAndFlush(Iterable<S> entities) {
        Iterable result = this.saveAll((Iterable)entities);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.entityManager.flush();
    }

    @Deprecated
    protected Page<T> readPage(TypedQuery<T> query, Pageable pageable, @Nullable Specification<T> spec) {
        return this.readPage(query, this.getDomainClass(), pageable, spec);
    }

    protected <S extends T> Page<S> readPage(TypedQuery<S> query, Class<S> domainClass, Pageable pageable, @Nullable Specification<S> spec) {
        if (pageable.isPaged()) {
            query.setFirstResult(PageableUtils.getOffsetAsInteger(pageable));
            query.setMaxResults(pageable.getPageSize());
        }
        return PageableExecutionUtils.getPage((List)query.getResultList(), (Pageable)pageable, () -> SimpleJpaRepository.executeCountQuery(this.getCountQuery(spec, domainClass)));
    }

    protected TypedQuery<T> getQuery(@Nullable Specification<T> spec, Pageable pageable) {
        return this.getQuery(spec, this.getDomainClass(), pageable.getSort());
    }

    protected <S extends T> TypedQuery<S> getQuery(@Nullable Specification<S> spec, Class<S> domainClass, Pageable pageable) {
        return this.getQuery(spec, domainClass, pageable.getSort());
    }

    protected TypedQuery<T> getQuery(@Nullable Specification<T> spec, Sort sort) {
        return this.getQuery(spec, this.getDomainClass(), sort);
    }

    protected <S extends T> TypedQuery<S> getQuery(@Nullable Specification<S> spec, Class<S> domainClass, Sort sort) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(domainClass);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        query.select(root);
        if (sort.isSorted()) {
            query.orderBy(QueryUtils.toOrders(sort, root, builder));
        }
        return this.applyRepositoryMethodMetadata(this.entityManager.createQuery(query));
    }

    @Deprecated
    protected TypedQuery<Long> getCountQuery(@Nullable Specification<T> spec) {
        return this.getCountQuery(spec, this.getDomainClass());
    }

    protected <S extends T> TypedQuery<Long> getCountQuery(@Nullable Specification<S> spec, Class<S> domainClass) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<S> root = this.applySpecificationToCriteria(spec, domainClass, query);
        if (query.isDistinct()) {
            query.select((Selection)builder.countDistinct(root));
        } else {
            query.select((Selection)builder.count(root));
        }
        query.orderBy(Collections.emptyList());
        return this.applyRepositoryMethodMetadataForCount(this.entityManager.createQuery(query));
    }

    protected QueryHints getQueryHints() {
        return this.metadata == null ? QueryHints.NoHints.INSTANCE : DefaultQueryHints.of(this.entityInformation, this.metadata);
    }

    protected QueryHints getQueryHintsForCount() {
        return this.metadata == null ? QueryHints.NoHints.INSTANCE : DefaultQueryHints.of(this.entityInformation, this.metadata).forCounts();
    }

    private <S, U extends T> Root<U> applySpecificationToCriteria(@Nullable Specification<U> spec, Class<U> domainClass, CriteriaQuery<S> query) {
        Assert.notNull(domainClass, (String)"Domain class must not be null");
        Assert.notNull(query, (String)"CriteriaQuery must not be null");
        Root root = query.from(domainClass);
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadata(TypedQuery<S> query) {
        if (this.metadata == null) {
            return query;
        }
        LockModeType type = this.metadata.getLockModeType();
        TypedQuery toReturn = type == null ? query : query.setLockMode(type);
        this.applyQueryHints((Query)toReturn);
        return toReturn;
    }

    private void applyQueryHints(Query query) {
        if (this.metadata == null) {
            return;
        }
        this.getQueryHints().withFetchGraphs(this.entityManager).forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
        this.applyComment(this.metadata, (arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
    }

    private <S> TypedQuery<S> applyRepositoryMethodMetadataForCount(TypedQuery<S> query) {
        if (this.metadata == null) {
            return query;
        }
        this.applyQueryHintsForCount((Query)query);
        return query;
    }

    private void applyQueryHintsForCount(Query query) {
        if (this.metadata == null) {
            return;
        }
        this.getQueryHintsForCount().forEach((arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
        this.applyComment(this.metadata, (arg_0, arg_1) -> ((Query)query).setHint(arg_0, arg_1));
    }

    private Map<String, Object> getHints() {
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.getQueryHints().withFetchGraphs(this.entityManager).forEach(hints::put);
        if (this.metadata != null) {
            this.applyComment(this.metadata, hints::put);
        }
        return hints;
    }

    private void applyComment(CrudMethodMetadata metadata, BiConsumer<String, Object> consumer) {
        if (metadata.getComment() != null && this.provider.getCommentHintKey() != null) {
            consumer.accept(this.provider.getCommentHintKey(), this.provider.getCommentHintValue(this.metadata.getComment()));
        }
    }

    private ProjectionFactory getProjectionFactory() {
        if (this.projectionFactory == null) {
            this.projectionFactory = new SpelAwareProxyProjectionFactory();
        }
        return this.projectionFactory;
    }

    private static <T> Collection<T> toCollection(Iterable<T> ids) {
        Collection collection;
        if (ids instanceof Collection) {
            Collection c = (Collection)ids;
            collection = c;
        } else {
            collection = Streamable.of(ids).toList();
        }
        return collection;
    }

    private static long executeCountQuery(TypedQuery<Long> query) {
        Assert.notNull(query, (String)"TypedQuery must not be null");
        List totals = query.getResultList();
        long total = 0L;
        for (Long element : totals) {
            total += element == null ? 0L : element;
        }
        return total;
    }

    private static final class ByIdsSpecification<T>
    implements Specification<T> {
        private static final long serialVersionUID = 1L;
        private final JpaEntityInformation<T, ?> entityInformation;
        @Nullable
        ParameterExpression<Collection<?>> parameter;

        ByIdsSpecification(JpaEntityInformation<T, ?> entityInformation) {
            this.entityInformation = entityInformation;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path path = root.get(this.entityInformation.getIdAttribute());
            this.parameter = cb.parameter(Collection.class);
            return path.in(this.parameter);
        }
    }

    private static class ExampleSpecification<T>
    implements Specification<T> {
        private static final long serialVersionUID = 1L;
        private final Example<T> example;
        private final EscapeCharacter escapeCharacter;

        ExampleSpecification(Example<T> example, EscapeCharacter escapeCharacter) {
            Assert.notNull(example, (String)SimpleJpaRepository.EXAMPLE_MUST_NOT_BE_NULL);
            Assert.notNull((Object)escapeCharacter, (String)"EscapeCharacter must not be null");
            this.example = example;
            this.escapeCharacter = escapeCharacter;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return QueryByExamplePredicateBuilder.getPredicate(root, cb, this.example, this.escapeCharacter);
        }
    }
}

