/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.synthetic;

import com.xebialabs.deployit.plugin.api.reflect.IDescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;

public final class TypeName {
    private final String prefix;
    private final String name;

    public TypeName(String typeName) {
        if (typeName.indexOf(46) == -1) {
            throw new IllegalArgumentException(String.format("Type %s does not contain a prefix", typeName));
        }
        int lastDot = typeName.lastIndexOf(46);
        this.prefix = typeName.substring(0, lastDot);
        this.name = typeName.substring(lastDot + 1);
    }

    public TypeName(String prefix, String name) {
        if (prefix == null || name == null) {
            throw new IllegalArgumentException("Either prefix or name is null, type should be fully qualified.");
        }
        this.prefix = prefix;
        this.name = name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeName type1 = (TypeName)o;
        return this.prefix.equals(type1.prefix) && this.name.equals(type1.name);
    }

    public int hashCode() {
        int result = this.prefix != null ? this.prefix.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.prefix + "." + this.name;
    }

    public Type toType(IDescriptorRegistry registry) {
        return registry.lookupType(this.toString());
    }
}

