/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;

@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public abstract class AbstractDelegatingCache<K, V>
implements Cache<K, V> {
    protected final Cache<K, V> cache;

    public AbstractDelegatingCache(Cache<K, V> cache) {
        this.cache = cache;
        if (cache == null) {
            throw new IllegalArgumentException("Delegate cache cannot be null!");
        }
    }

    @Override
    public void putForExternalRead(K key, V value) {
        this.cache.putForExternalRead(key, value);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit unit) {
        this.cache.putForExternalRead(key, value, lifespan, unit);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        this.cache.putForExternalRead(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public void evict(K key) {
        this.cache.evict(key);
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.cache.getCacheConfiguration();
    }

    public boolean startBatch() {
        return this.cache.startBatch();
    }

    public void endBatch(boolean successful) {
        this.cache.endBatch(successful);
    }

    public String getName() {
        return this.cache.getName();
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT)
    public String getCacheName() {
        return this.getName() + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT)
    public String getVersion() {
        return this.cache.getVersion();
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cache.getCacheManager();
    }

    public V put(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.put(key, value, lifespan, unit);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.putIfAbsent(key, value, lifespan, unit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.cache.putAll(map, lifespan, unit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.cache.replace(key, value, lifespan, unit);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.cache.replace(key, oldValue, value, lifespan, unit);
    }

    public V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.put(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this.cache.putAll(map, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.replace(key, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return this.cache.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.cache.replaceAll(function);
    }

    public CompletableFuture<V> putAsync(K key, V value) {
        return this.cache.putAsync(key, value);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.cache.putAllAsync(data);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.cache.putAllAsync(data, lifespan, unit);
    }

    public CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Void> clearAsync() {
        return this.cache.clearAsync();
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.cache.putIfAbsentAsync(key, value);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<V> removeAsync(Object key) {
        return this.cache.removeAsync(key);
    }

    public CompletableFuture<Boolean> removeAsync(Object key, Object value) {
        return this.cache.removeAsync(key, value);
    }

    public CompletableFuture<V> replaceAsync(K key, V value) {
        return this.cache.replaceAsync(key, value);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, value, lifespan, unit);
    }

    public CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.cache.replaceAsync(key, oldValue, newValue);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, unit);
    }

    public CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeAsync(key, remappingFunction);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> computeIfAbsentAsync(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfAbsentAsync(key, mappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeIfPresentAsync(key, remappingFunction);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit);
    }

    public CompletableFuture<V> computeIfPresentAsync(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.computeIfPresentAsync(key, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.cache.mergeAsync(key, value, remappingFunction);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public CompletableFuture<V> mergeAsync(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.cache.mergeAsync(key, value, remappingFunction, lifespan, lifespanUnit, maxIdle, maxIdleUnit);
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this.cache.getAdvancedCache();
    }

    @Override
    public ComponentStatus getStatus() {
        return this.cache.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    public V putIfAbsent(K key, V value) {
        return (V)this.cache.putIfAbsent(key, value);
    }

    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(key, oldValue, newValue);
    }

    public V replace(K key, V value) {
        return (V)this.cache.replace(key, value);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public CompletableFuture<Long> sizeAsync() {
        return this.cache.sizeAsync();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return (V)this.cache.compute(key, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.compute(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.cache.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return (V)this.cache.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit);
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.computeIfPresent(key, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.cache.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return (V)this.cache.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.computeIfAbsent(key, mappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public V get(Object key) {
        return (V)this.cache.get(key);
    }

    public V getOrDefault(Object key, V defaultValue) {
        return (V)this.cache.getOrDefault(key, defaultValue);
    }

    public V put(K key, V value) {
        return (V)this.cache.put(key, value);
    }

    public V remove(Object key) {
        return (V)this.cache.remove(key);
    }

    public void putAll(Map<? extends K, ? extends V> t) {
        this.cache.putAll(t);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.cache.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return (V)this.cache.merge(key, value, remappingFunction, lifespan, lifespanUnit);
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return (V)this.cache.merge(key, value, remappingFunction, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.cache.forEach(action);
    }

    @Override
    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public void clear() {
        this.cache.clear();
    }

    @Override
    public CacheSet<K> keySet() {
        return this.cache.keySet();
    }

    @Override
    public CacheSet<Map.Entry<K, V>> entrySet() {
        return this.cache.entrySet();
    }

    @Override
    public CacheCollection<V> values() {
        return this.cache.values();
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.cache.start();
    }

    @Override
    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.cache.stop();
    }

    @Override
    @ManagedOperation(description="Shuts down the cache across the cluster", displayName="Clustered cache shutdown")
    public void shutdown() {
        this.cache.shutdown();
    }

    @Override
    public void addListener(Object listener) {
        this.cache.addListener(listener);
    }

    @Override
    public CompletionStage<Void> addListenerAsync(Object listener) {
        return this.cache.addListenerAsync(listener);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.cache.addListener(listener, filter, converter);
    }

    @Override
    public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        return this.cache.addListenerAsync(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.cache.removeListener(listener);
    }

    @Override
    public CompletionStage<Void> removeListenerAsync(Object listener) {
        return this.cache.removeListenerAsync(listener);
    }

    @Override
    @Deprecated(forRemoval=true)
    public Set<Object> getListeners() {
        return this.cache.getListeners();
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.cache.addFilteredListener(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.cache.addFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> void addStorageFormatFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.cache.addStorageFormatFilteredListener(listener, filter, converter, filterAnnotations);
    }

    @Override
    public <C> CompletionStage<Void> addStorageFormatFilteredListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        return this.cache.addStorageFormatFilteredListenerAsync(listener, filter, converter, filterAnnotations);
    }

    public CompletableFuture<V> getAsync(K key) {
        return this.cache.getAsync(key);
    }

    public CompletableFuture<Map<K, V>> getAllAsync(Set<?> keys) {
        return this.cache.getAllAsync(keys);
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.getCacheConfiguration());
    }

    public String toString() {
        return this.cache.toString();
    }

    public Cache<K, V> getDelegate() {
        return this.cache;
    }

    public static <K, V> Cache<K, V> unwrapCache(Cache<K, V> cache) {
        if (cache instanceof AbstractDelegatingCache) {
            return AbstractDelegatingCache.unwrapCache(((AbstractDelegatingCache)cache).getDelegate());
        }
        return cache;
    }
}

