/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.functions;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;

public interface Either<L, R> {
    public static <L, R> Either<L, R> right(R right) {
        return new Right(right);
    }

    public static <L, R> Either<L, R> left(L left) {
        return new Left(left);
    }

    public L getLeft();

    public boolean isLeft();

    public boolean isRight();

    public R get();

    default public Either<R, L> swap() {
        if (this.isRight()) {
            return new Left(this.get());
        }
        return new Right(this.getLeft());
    }

    default public boolean isEmpty() {
        return this.isLeft();
    }

    default public R getOrNull() {
        return this.isEmpty() ? null : (R)this.get();
    }

    default public <U> Either<U, R> mapLeft(Function<? super L, ? extends U> leftMapper) {
        Objects.requireNonNull(leftMapper, "leftMapper is null");
        if (this.isLeft()) {
            return Either.left(leftMapper.apply(this.getLeft()));
        }
        return this;
    }

    default public <U> Either<L, U> map(Function<? super R, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        if (this.isRight()) {
            return Either.right(mapper.apply(this.get()));
        }
        return this;
    }

    default public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
        Objects.requireNonNull(leftMapper, "leftMapper is null");
        Objects.requireNonNull(rightMapper, "rightMapper is null");
        if (this.isRight()) {
            return rightMapper.apply(this.get());
        }
        return leftMapper.apply(this.getLeft());
    }

    public static final class Right<L, R>
    implements Either<L, R>,
    Serializable {
        private final R value;

        private Right(R value) {
            this.value = value;
        }

        @Override
        public R get() {
            return this.value;
        }

        @Override
        public L getLeft() {
            throw new NoSuchElementException("getLeft() on Right");
        }

        @Override
        public boolean isLeft() {
            return false;
        }

        @Override
        public boolean isRight() {
            return true;
        }
    }

    public static final class Left<L, R>
    implements Either<L, R>,
    Serializable {
        private final L value;

        private Left(L value) {
            this.value = value;
        }

        @Override
        public R get() {
            throw new NoSuchElementException("get() on Left");
        }

        @Override
        public L getLeft() {
            return this.value;
        }

        @Override
        public boolean isLeft() {
            return true;
        }

        @Override
        public boolean isRight() {
            return false;
        }
    }
}

