/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.infinispan.protostream.annotations.ProtoSyntax;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.HasProtoSchema;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoMessageTypeMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XExecutable;
import org.infinispan.protostream.annotations.impl.types.XField;
import org.infinispan.protostream.annotations.impl.types.XMember;
import org.infinispan.protostream.annotations.impl.types.XMethod;
import org.infinispan.protostream.annotations.impl.types.XTypeFactory;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;

public class ProtoFieldMetadata
implements HasProtoSchema {
    private final int number;
    private final String name;
    private final String oneof;
    private final XClass javaType;
    private final XClass repeatedImplementation;
    private final Type protobufType;
    private final String documentation;
    private final ProtoTypeMetadata protoTypeMetadata;
    private final boolean isRequired;
    private final boolean isRepeated;
    private final boolean isArray;
    private final Object defaultValue;
    private final String propertyName;
    private final XMember declaringMember;
    private final XField field;
    private final XMethod getter;
    private final XMethod setter;

    ProtoFieldMetadata(int number, String name, String oneof, XClass javaType, XClass repeatedImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, boolean isArray, Object defaultValue, XField field) {
        this.number = number;
        this.name = name;
        this.oneof = oneof;
        this.javaType = javaType;
        this.repeatedImplementation = repeatedImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.isArray = isArray;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.declaringMember = field;
        this.field = field;
        this.getter = null;
        this.setter = null;
        this.documentation = field.getDocumentation();
        this.propertyName = field.getName();
    }

    ProtoFieldMetadata(int number, String name, String oneof, XClass javaType, XClass repeatedImplementation, Type protobufType, ProtoTypeMetadata protoTypeMetadata, boolean isRequired, boolean isRepeated, boolean isArray, Object defaultValue, String propertyName, XMethod definingMethod, XMethod getter, XMethod setter) {
        this.number = number;
        this.name = name;
        this.oneof = oneof;
        this.javaType = javaType;
        this.repeatedImplementation = repeatedImplementation;
        this.protoTypeMetadata = protoTypeMetadata;
        this.isRequired = isRequired;
        this.isRepeated = isRepeated;
        this.isArray = isArray;
        this.defaultValue = defaultValue;
        this.protobufType = protobufType;
        this.field = null;
        this.propertyName = propertyName;
        this.declaringMember = definingMethod;
        this.getter = getter;
        this.setter = setter;
        this.documentation = definingMethod.getDocumentation();
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getOneof() {
        return this.oneof;
    }

    public XClass getJavaType() {
        return this.javaType;
    }

    public String getJavaTypeName() {
        String canonicalName = this.javaType.getCanonicalName();
        return canonicalName != null ? canonicalName : this.javaType.getName();
    }

    public XClass getRepeatedImplementation() {
        return this.repeatedImplementation;
    }

    public Type getProtobufType() {
        return this.protobufType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isMap() {
        return false;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public XField getField() {
        return this.field;
    }

    public XMethod getGetter() {
        return this.getter;
    }

    public XMethod getSetter() {
        return this.setter;
    }

    public String getLocation() {
        return this.declaringMember instanceof XExecutable ? ((XExecutable)this.declaringMember).toGenericString() : this.declaringMember.toString();
    }

    @Override
    public void generateProto(IndentWriter iw, ProtoSyntax syntax) {
        Object defaultValue;
        iw.append('\n');
        ProtoTypeMetadata.appendDocumentation(iw, this.documentation);
        if (this.oneof == null) {
            if (this.isRepeated) {
                iw.append("repeated ");
            } else if (syntax == ProtoSyntax.PROTO2) {
                iw.append(this.isRequired ? "required " : "optional ");
            }
        }
        String typeName = this.getTypeName();
        iw.append(typeName);
        iw.append(' ').append(this.name).append(" = ").append(String.valueOf(this.number));
        if (syntax == ProtoSyntax.PROTO2 && (defaultValue = this.getDefaultValue()) != null) {
            Object v = defaultValue instanceof ProtoEnumValueMetadata ? ((ProtoEnumValueMetadata)defaultValue).getProtoName() : (defaultValue instanceof Date ? Long.toString(((Date)defaultValue).getTime()) : (defaultValue instanceof Character ? Integer.toString(((Character)defaultValue).charValue()) : (defaultValue instanceof byte[] ? "\"" + new String(ProtoMessageTypeMetadata.cescape((byte[])defaultValue), StandardCharsets.ISO_8859_1) + "\"" : (defaultValue instanceof String ? "\"" + String.valueOf(defaultValue) + "\"" : defaultValue.toString()))));
            iw.append(" [default = ").append((CharSequence)v).append(']');
        }
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ");
            if (this.field != null) {
                iw.append("field = ").append(this.field.getDeclaringClass().getCanonicalName()).append('.').append(this.field.getName());
            } else {
                iw.append("getter = ").append(this.getter.getDeclaringClass().getCanonicalName()).append('.').append(this.getter.getName());
                if (this.setter != null) {
                    iw.append(", setter = ").append(this.setter.getDeclaringClass().getCanonicalName()).append('.').append(this.setter.getName());
                }
            }
            iw.append(" */");
        }
        iw.append(";\n");
    }

    protected String getTypeName() {
        String typeName;
        if (this.protobufType.getJavaType() == JavaType.ENUM || this.protobufType.getJavaType() == JavaType.MESSAGE) {
            typeName = this.protoTypeMetadata.getFullName();
        } else {
            typeName = switch (this.protobufType) {
                case Type.DOUBLE -> "double";
                case Type.FLOAT -> "float";
                case Type.INT32 -> "int32";
                case Type.INT64 -> "int64";
                case Type.FIXED32 -> "fixed32";
                case Type.FIXED64 -> "fixed64";
                case Type.BOOL -> "bool";
                case Type.STRING -> "string";
                case Type.BYTES -> "bytes";
                case Type.UINT32 -> "uint32";
                case Type.UINT64 -> "uint64";
                case Type.SFIXED32 -> "sfixed32";
                case Type.SFIXED64 -> "sfixed64";
                case Type.SINT32 -> "sint32";
                case Type.SINT64 -> "sint64";
                default -> throw new IllegalStateException("Unknown field type " + String.valueOf((Object)this.protobufType));
            };
        }
        return typeName;
    }

    public boolean isPrimitive() {
        XTypeFactory factory = this.javaType.getFactory();
        return this.javaType == factory.fromClass(Float.TYPE) || this.javaType == factory.fromClass(Double.TYPE) || this.javaType == factory.fromClass(Long.TYPE) || this.javaType == factory.fromClass(Integer.TYPE) || this.javaType == factory.fromClass(Short.TYPE) || this.javaType == factory.fromClass(Byte.TYPE) || this.javaType == factory.fromClass(Boolean.TYPE) || this.javaType == factory.fromClass(Character.TYPE);
    }

    public boolean isBoxedPrimitive() {
        XTypeFactory factory = this.javaType.getFactory();
        return this.javaType == factory.fromClass(Float.class) || this.javaType == factory.fromClass(Double.class) || this.javaType == factory.fromClass(Long.class) || this.javaType == factory.fromClass(Integer.class) || this.javaType == factory.fromClass(Short.class) || this.javaType == factory.fromClass(Byte.class) || this.javaType == factory.fromClass(Boolean.class) || this.javaType == factory.fromClass(Character.class);
    }

    public String toString() {
        return "ProtoFieldMetadata{number=" + this.number + ", name='" + this.name + "', protobufType=" + String.valueOf((Object)this.protobufType) + ", javaType=" + String.valueOf(this.javaType) + ", collectionImplementation=" + String.valueOf(this.repeatedImplementation) + ", oneof=" + this.oneof + ", documentation='" + this.documentation + "', protoTypeMetadata=" + (this.protoTypeMetadata != null ? this.protoTypeMetadata.getName() : null) + ", isRequired=" + this.isRequired + ", isRepeated=" + this.isRepeated + ", isArray=" + this.isArray + ", defaultValue=" + String.valueOf(this.defaultValue) + ", propertyName='" + this.propertyName + "', declaringMember=" + String.valueOf(this.declaringMember) + ", field=" + String.valueOf(this.field) + ", getter=" + String.valueOf(this.getter) + ", setter=" + String.valueOf(this.setter) + "}";
    }
}

