/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.LinkRefDerived;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.ReferencingNode;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class RefNode
extends Node
implements LinkRefDerived,
ReferencingNode<ReferenceRepository, Reference>,
DoNotLinkDecorate,
TextContainer {
    protected BasedSequence textOpeningMarker = BasedSequence.NULL;
    protected BasedSequence text = BasedSequence.NULL;
    protected BasedSequence textClosingMarker = BasedSequence.NULL;
    protected BasedSequence referenceOpeningMarker = BasedSequence.NULL;
    protected BasedSequence reference = BasedSequence.NULL;
    protected BasedSequence referenceClosingMarker = BasedSequence.NULL;
    protected boolean isDefined = false;

    @NotNull
    public BasedSequence[] getSegments() {
        if (this.isReferenceTextCombined()) {
            return new BasedSequence[]{this.referenceOpeningMarker, this.reference, this.referenceClosingMarker, this.textOpeningMarker, this.text, this.textClosingMarker};
        }
        return new BasedSequence[]{this.textOpeningMarker, this.text, this.textClosingMarker, this.referenceOpeningMarker, this.reference, this.referenceClosingMarker};
    }

    public void getAstExtra(@NotNull StringBuilder out) {
        if (this.isReferenceTextCombined()) {
            RefNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.referenceOpeningMarker, (BasedSequence)this.reference, (BasedSequence)this.referenceClosingMarker, (String)"reference");
            RefNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.textOpeningMarker, (BasedSequence)this.text, (BasedSequence)this.textClosingMarker, (String)"text");
        } else {
            RefNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.textOpeningMarker, (BasedSequence)this.text, (BasedSequence)this.textClosingMarker, (String)"text");
            RefNode.delimitedSegmentSpanChars((StringBuilder)out, (BasedSequence)this.referenceOpeningMarker, (BasedSequence)this.reference, (BasedSequence)this.referenceClosingMarker, (String)"reference");
        }
    }

    public RefNode() {
    }

    public RefNode(BasedSequence chars) {
        super(chars);
    }

    public RefNode(BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence referenceOpeningMarker, BasedSequence reference, BasedSequence referenceClosingMarker) {
        super(textOpeningMarker.baseSubSequence(textOpeningMarker.getStartOffset(), referenceClosingMarker.getEndOffset()));
        this.textOpeningMarker = textOpeningMarker;
        this.text = text;
        this.textClosingMarker = textClosingMarker;
        this.referenceOpeningMarker = referenceOpeningMarker;
        this.reference = reference;
        this.referenceClosingMarker = referenceClosingMarker;
    }

    public RefNode(BasedSequence chars, BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence referenceOpeningMarker, BasedSequence reference, BasedSequence referenceClosingMarker) {
        super(chars);
        this.textOpeningMarker = textOpeningMarker;
        this.text = text;
        this.textClosingMarker = textClosingMarker;
        this.referenceOpeningMarker = referenceOpeningMarker;
        this.reference = reference;
        this.referenceClosingMarker = referenceClosingMarker;
    }

    public RefNode(BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker) {
        super(textOpeningMarker.baseSubSequence(textOpeningMarker.getStartOffset(), textClosingMarker.getEndOffset()));
        this.textOpeningMarker = textOpeningMarker;
        this.text = text;
        this.textClosingMarker = textClosingMarker;
    }

    public RefNode(BasedSequence chars, BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker) {
        super(chars);
        this.textOpeningMarker = textOpeningMarker;
        this.text = text;
        this.textClosingMarker = textClosingMarker;
    }

    public RefNode(BasedSequence textOpeningMarker, BasedSequence text, BasedSequence textClosingMarker, BasedSequence referenceOpeningMarker, BasedSequence referenceClosingMarker) {
        super(textOpeningMarker.baseSubSequence(textOpeningMarker.getStartOffset(), referenceClosingMarker.getEndOffset()));
        this.textOpeningMarker = textOpeningMarker;
        this.text = text;
        this.textClosingMarker = textClosingMarker;
        this.referenceOpeningMarker = referenceOpeningMarker;
        this.referenceClosingMarker = referenceClosingMarker;
    }

    public void setReferenceChars(BasedSequence referenceChars) {
        int referenceCharsLength = referenceChars.length();
        int openingOffset = referenceChars.charAt(0) == '!' ? 2 : 1;
        this.referenceOpeningMarker = referenceChars.subSequence(0, openingOffset);
        this.reference = (BasedSequence)referenceChars.subSequence(openingOffset, referenceCharsLength - 1).trim();
        this.referenceClosingMarker = referenceChars.subSequence(referenceCharsLength - 1, referenceCharsLength);
    }

    public void setTextChars(BasedSequence textChars) {
        int textCharsLength = textChars.length();
        this.textOpeningMarker = textChars.subSequence(0, 1);
        this.text = (BasedSequence)textChars.subSequence(1, textCharsLength - 1).trim();
        this.textClosingMarker = textChars.subSequence(textCharsLength - 1, textCharsLength);
    }

    public boolean isReferenceTextCombined() {
        return this.text == BasedSequence.NULL;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public void setDefined(boolean defined) {
        this.isDefined = defined;
    }

    @Override
    public boolean isTentative() {
        return !this.isDefined;
    }

    public boolean isDummyReference() {
        return this.textOpeningMarker != BasedSequence.NULL && this.text == BasedSequence.NULL && this.textClosingMarker != BasedSequence.NULL;
    }

    public BasedSequence getText() {
        return this.text;
    }

    @NotNull
    public BasedSequence getReference() {
        return this.reference;
    }

    public Reference getReferenceNode(Document document) {
        return this.getReferenceNode((ReferenceRepository)((Object)Parser.REFERENCES.get((DataHolder)document)));
    }

    public Reference getReferenceNode(ReferenceRepository repository) {
        if (repository == null) {
            return null;
        }
        String normalizeRef = repository.normalizeKey((CharSequence)this.reference);
        return (Reference)((Object)repository.get(normalizeRef));
    }

    public BasedSequence getTextOpeningMarker() {
        return this.textOpeningMarker;
    }

    public void setTextOpeningMarker(BasedSequence textOpeningMarker) {
        this.textOpeningMarker = textOpeningMarker;
    }

    public void setText(BasedSequence text) {
        this.text = text;
    }

    public BasedSequence getTextClosingMarker() {
        return this.textClosingMarker;
    }

    public void setTextClosingMarker(BasedSequence textClosingMarker) {
        this.textClosingMarker = textClosingMarker;
    }

    public BasedSequence getReferenceOpeningMarker() {
        return this.referenceOpeningMarker;
    }

    public void setReferenceOpeningMarker(BasedSequence referenceOpeningMarker) {
        this.referenceOpeningMarker = referenceOpeningMarker;
    }

    public void setReference(BasedSequence reference) {
        this.reference = reference;
    }

    public BasedSequence getDummyReference() {
        if (this.isDummyReference()) {
            return this.getChars().baseSubSequence(this.textOpeningMarker.getStartOffset(), this.textClosingMarker.getEndOffset());
        }
        return BasedSequence.NULL;
    }

    public BasedSequence getReferenceClosingMarker() {
        return this.referenceClosingMarker;
    }

    public void setReferenceClosingMarker(BasedSequence referenceClosingMarker) {
        this.referenceClosingMarker = referenceClosingMarker;
    }

    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags) {
        int urlType = flags & F_LINK_TEXT_TYPE;
        if (urlType == 0) {
            return true;
        }
        Reference reference = this.getReferenceNode(this.getDocument());
        if (urlType == 4) {
            out.append((CharSequence)this.getChars());
        } else {
            BasedSequence url;
            if (reference == null) {
                return true;
            }
            switch (urlType) {
                case 1: {
                    url = reference.getPageRef();
                    break;
                }
                case 2: {
                    url = reference.getAnchorRef();
                    break;
                }
                case 3: {
                    url = reference.getUrl();
                    break;
                }
                default: {
                    return true;
                }
            }
            ReplacedTextMapper textMapper = new ReplacedTextMapper(url);
            BasedSequence unescaped = Escaping.unescape((BasedSequence)url, (ReplacedTextMapper)textMapper);
            BasedSequence percentDecoded = Escaping.percentDecodeUrl((BasedSequence)unescaped, (ReplacedTextMapper)textMapper);
            out.append((CharSequence)percentDecoded);
        }
        return false;
    }

    @NotNull
    protected String toStringAttributes() {
        return "text=" + this.text + ", reference=" + this.reference;
    }
}

