/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.shared.common.i18n.MessageService;

public class CloseFilterInputStream
extends FilterInputStream {
    private static final String MESSAGE = MessageService.getTextMessage((String)"J104", (Object[])new Object[0]);
    private boolean closed;

    public CloseFilterInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        super.close();
    }

    @Override
    public int available() throws IOException {
        this.checkIfClosed();
        return super.available();
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        return super.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        this.checkIfClosed();
        return super.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkIfClosed();
        return super.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkIfClosed();
        return super.skip(l);
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(MESSAGE);
        }
    }
}

