/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.resizable.image.internal;

import com.vladsch.flexmark.ext.resizable.image.ResizableImage;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ResizableImageNodeRenderer
implements NodeRenderer {
    public ResizableImageNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(ResizableImage.class, this::render));
        return set;
    }

    public void render(ResizableImage node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink link = context.resolveLink(LinkType.IMAGE, (CharSequence)node.getSource(), Boolean.valueOf(true));
            html.srcPos(node.getChars()).attr((CharSequence)"src", (CharSequence)link.getUrl());
            if (node.getText().isNotEmpty()) {
                html.attr((CharSequence)"alt", (CharSequence)node.getText());
            }
            if (node.getWidth().isNotEmpty()) {
                html.attr((CharSequence)"width", (CharSequence)(node.getWidth() + "px"));
            }
            if (node.getHeight().isNotEmpty()) {
                html.attr((CharSequence)"height", (CharSequence)(node.getHeight() + "px"));
            }
            html.withAttr().tag((CharSequence)"img");
            html.tag((CharSequence)"/img");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new ResizableImageNodeRenderer(options);
        }
    }
}

