/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.plugin.manager.repository;

import com.xebialabs.plugin.manager.PluginId;
import com.xebialabs.plugin.manager.exception.PluginRepositoryException;
import com.xebialabs.plugin.manager.metadata.Version;
import com.xebialabs.plugin.manager.metadata.Version$;
import com.xebialabs.plugin.manager.metadata.Version$VersionOps$;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.Uri;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class package$ {
    public static final package$ MODULE$ = new package$();

    public Uri.Query paramsToQuery(Map<String, Option<String>> params) {
        return Uri.Query$.MODULE$.apply((Map)params.collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String k = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String v = (String)some.value();
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Option<String>> x1) {
                Option option;
                Tuple2<String, Option<String>> tuple2 = x1;
                return tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
            }
        }));
    }

    public HttpEntity EntityOps(HttpEntity entity) {
        return entity;
    }

    public HttpResponse RespSyntax(HttpResponse resp) {
        return resp;
    }

    public Future<Tuple2<String, Object>> verifyPlugin(PluginId.Artifact pluginId, byte[] sha1, byte[] plugin, Option<Object> length) {
        return Future$.MODULE$.fromTry(this.verifySHA1(pluginId, sha1, plugin).flatMap((Function1 & Serializable)digest -> MODULE$.verifyContentLength(pluginId, length, plugin.length).map((Function1 & Serializable)length -> package$.$anonfun$verifyPlugin$2(digest, BoxesRunTime.unboxToLong((Object)length)))));
    }

    public Option<Version> latestVersion(Version pv, Seq<Version> versions) {
        return ((IterableOps)((SeqOps)versions.filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.isProductVersion(pv, v)))).sortBy((Function1 & Serializable)x$4 -> Version$VersionOps$.MODULE$.id$extension(Version$.MODULE$.VersionOps((Version)x$4)), (Ordering)Ordering.String$.MODULE$)).lastOption();
    }

    private Try<Object> verifyContentLength(PluginId.Artifact pluginId, Option<Object> expected, long found) {
        boolean bl = false;
        Some some = null;
        Option<Object> option = expected;
        if (None$.MODULE$.equals(option)) {
            return new Success((Object)BoxesRunTime.boxToLong((long)found));
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            long length = BoxesRunTime.unboxToLong((Object)some.value());
            if (found == length) {
                return new Success((Object)BoxesRunTime.boxToLong((long)found));
            }
        }
        if (bl) {
            long length = BoxesRunTime.unboxToLong((Object)some.value());
            return new Failure((Throwable)((Object)new PluginRepositoryException.ContentLengthMismatch(pluginId, found, length)));
        }
        throw new MatchError(option);
    }

    private Try<String> verifySHA1(PluginId.Artifact pluginId, byte[] expected, byte[] found) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> new String(expected, StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)sha1 -> Try$.MODULE$.apply((Function0 & Serializable)() -> DigestUtils.sha1Hex((byte[])found)).flatMap((Function1 & Serializable)digest -> {
            String string = digest;
            String string2 = sha1;
            return (!(string != null ? !string.equals(string2) : string2 != null) ? new Success(digest) : new Failure((Throwable)((Object)new PluginRepositoryException.ChecksumMismatch(pluginId, (String)digest, (String)sha1)))).map((Function1 & Serializable)result -> result);
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isProductVersion(Version pv, Version v) {
        if (pv.major() != v.major()) return false;
        Option<Object> option = pv.minor();
        Option<Object> option2 = v.minor();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = pv.revision();
        Option<Object> option4 = v.revision();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$verifyPlugin$2(String digest$1, long length) {
        return new Tuple2((Object)digest$1, (Object)BoxesRunTime.boxToLong((long)length));
    }

    private package$() {
    }
}

