/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.URLFileName;
import org.apache.commons.vfs2.provider.http.HttpFileContentInfoFactory;
import org.apache.commons.vfs2.provider.http.HttpFileSystem;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.http.HttpRandomAccessContent;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.RandomAccessMode;

@Deprecated
public class HttpFileObject<FS extends HttpFileSystem>
extends AbstractFileObject<FS> {
    private final String urlCharset;
    private final String userAgent;
    private final boolean followRedirect;
    private HeadMethod method;

    protected HttpFileObject(AbstractFileName fileName, FS fileSystem) {
        this(fileName, fileSystem, HttpFileSystemConfigBuilder.getInstance());
    }

    protected HttpFileObject(AbstractFileName fileName, FS fileSystem, HttpFileSystemConfigBuilder builder) {
        super(fileName, fileSystem);
        FileSystemOptions fileSystemOptions = ((AbstractFileSystem)fileSystem).getFileSystemOptions();
        this.urlCharset = builder.getUrlCharset(fileSystemOptions);
        this.userAgent = builder.getUserAgent(fileSystemOptions);
        this.followRedirect = builder.getFollowRedirect(fileSystemOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDetach() throws Exception {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            this.method = null;
        }
    }

    @Override
    protected long doGetContentSize() throws Exception {
        Header header = this.getHeadMethod().getResponseHeader("content-length");
        if (header == null) {
            return 0L;
        }
        return Long.parseLong(header.getValue());
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        GetMethod getMethod = new GetMethod();
        this.setupMethod((HttpMethod)getMethod);
        int status = ((HttpFileSystem)this.getAbstractFileSystem()).getClient().executeMethod((HttpMethod)getMethod);
        if (status == 404) {
            throw new FileNotFoundException(this.getName());
        }
        if (status != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName(), status);
        }
        return new HttpInputStream(getMethod, bufferSize);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        Header header = this.getHeadMethod().getResponseHeader("last-modified");
        FileSystemException.requireNonNull(header, "vfs.provider.http/last-modified.error", this.getName());
        return DateUtil.parseDate((String)header.getValue()).getTime();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new HttpRandomAccessContent(this, mode);
    }

    @Override
    protected FileType doGetType() throws Exception {
        int status = this.getHeadMethod().getStatusCode();
        if (status == 200 || status == 405) {
            return FileType.FILE;
        }
        if (status == 404 || status == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName(), status);
    }

    @Override
    protected boolean doIsWriteable() throws Exception {
        return false;
    }

    @Override
    protected String[] doListChildren() throws Exception {
        throw new UnsupportedOperationException("Not implemented.");
    }

    protected String encodePath(String unescaped) throws URIException {
        return URIUtil.encodePath((String)unescaped);
    }

    @Override
    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new HttpFileContentInfoFactory();
    }

    protected boolean getFollowRedirect() {
        return this.followRedirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HeadMethod getHeadMethod() throws IOException {
        FileSystem fileSystem = this.getFileSystem();
        synchronized (fileSystem) {
            if (this.method != null) {
                return this.method;
            }
            this.method = new HeadMethod();
            try {
                this.setupMethod((HttpMethod)this.method);
                HttpClient client = ((HttpFileSystem)this.getAbstractFileSystem()).getClient();
                client.executeMethod((HttpMethod)this.method);
            }
            finally {
                this.method.releaseConnection();
            }
            return this.method;
        }
    }

    protected String getUrlCharset() {
        return this.urlCharset;
    }

    protected String getUserAgent() {
        return this.userAgent;
    }

    protected void setupMethod(HttpMethod method) throws FileSystemException, URIException {
        String pathEncoded = ((URLFileName)this.getName()).getPathQueryEncoded(this.getUrlCharset());
        method.setPath(pathEncoded);
        method.setFollowRedirects(this.getFollowRedirect());
        method.setRequestHeader("User-Agent", this.getUserAgent());
    }

    static class HttpInputStream
    extends MonitorInputStream {
        private final GetMethod method;

        HttpInputStream(GetMethod method) throws IOException {
            super(method.getResponseBodyAsStream());
            this.method = method;
        }

        HttpInputStream(GetMethod method, int bufferSize) throws IOException {
            super(method.getResponseBodyAsStream(), bufferSize);
            this.method = method;
        }

        @Override
        protected void onClose() throws IOException {
            this.method.releaseConnection();
        }
    }
}

