/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.main.collectors.VarNamesCollector;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodProcessorRunnable;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class ClassWrapper {
    private final StructClass classStruct;
    private final Set<String> hiddenMembers = new HashSet<String>();
    private final VBStyleCollection<Exprent, String> staticFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<Exprent, String> dynamicFieldInitializers = new VBStyleCollection();
    private final VBStyleCollection<MethodWrapper, String> methods = new VBStyleCollection();

    public ClassWrapper(StructClass classStruct) {
        this.classStruct = classStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws IOException {
        DecompilerContext.setProperty("CURRENT_CLASS", this.classStruct);
        DecompilerContext.setProperty("CURRENT_CLASS_WRAPPER", this);
        DecompilerContext.getLogger().startClass(this.classStruct.qualifiedName);
        int maxSec = Integer.parseInt(DecompilerContext.getProperty("mpm").toString());
        boolean testMode = DecompilerContext.getOption("__unit_test_mode__");
        for (StructMethod mt : this.classStruct.getMethods()) {
            boolean isError;
            RootStatement root;
            VarProcessor varProc;
            CounterContainer counter;
            block18: {
                DecompilerContext.getLogger().startMethod(mt.getName() + " " + mt.getDescriptor());
                VarNamesCollector vc = new VarNamesCollector();
                DecompilerContext.setVarNamesCollector(vc);
                counter = new CounterContainer();
                DecompilerContext.setCounterContainer(counter);
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
                varProc = new VarProcessor(mt, md);
                DecompilerContext.setProperty("CURRENT_VAR_PROCESSOR", varProc);
                root = null;
                isError = false;
                try {
                    if (mt.containsCode()) {
                        if (maxSec == 0 || testMode) {
                            root = MethodProcessorRunnable.codeToJava(mt, md, varProc);
                            break block18;
                        }
                        MethodProcessorRunnable mtProc = new MethodProcessorRunnable(mt, md, varProc, DecompilerContext.getCurrentContext());
                        Thread mtThread = new Thread((Runnable)mtProc, "Java decompiler");
                        long stopAt = System.currentTimeMillis() + (long)(maxSec * 1000);
                        mtThread.start();
                        while (!mtProc.isFinished()) {
                            try {
                                Object object = mtProc.lock;
                                synchronized (object) {
                                    mtProc.lock.wait(200L);
                                }
                            }
                            catch (InterruptedException e) {
                                ClassWrapper.killThread(mtThread);
                                throw e;
                            }
                            if (System.currentTimeMillis() < stopAt) continue;
                            String message = "Processing time limit exceeded for method " + mt.getName() + ", execution interrupted.";
                            DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.ERROR);
                            ClassWrapper.killThread(mtThread);
                            isError = true;
                            break;
                        }
                        if (!isError) {
                            root = mtProc.getResult();
                        }
                        break block18;
                    }
                    boolean thisVar = !mt.hasModifier(8);
                    int paramCount = 0;
                    if (thisVar) {
                        varProc.getThisVars().put(new VarVersionPair(0, 0), this.classStruct.qualifiedName);
                        paramCount = 1;
                    }
                    paramCount += md.params.length;
                    int varIndex = 0;
                    for (int i = 0; i < paramCount; ++i) {
                        varProc.setVarName(new VarVersionPair(varIndex, 0), vc.getFreeName(varIndex));
                        if (thisVar) {
                            if (i == 0) {
                                ++varIndex;
                                continue;
                            }
                            varIndex += md.params[i - 1].stackSize;
                            continue;
                        }
                        varIndex += md.params[i].stackSize;
                    }
                }
                catch (Throwable ex) {
                    DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " couldn't be decompiled.", IFernflowerLogger.Severity.WARN, ex);
                    isError = true;
                }
            }
            MethodWrapper methodWrapper = new MethodWrapper(root, varProc, mt, counter);
            methodWrapper.decompiledWithErrors = isError;
            this.methods.addWithKey(methodWrapper, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
            if (!isError) {
                StructLocalVariableTableAttribute attr;
                VarNamesCollector namesCollector = new VarNamesCollector();
                this.classStruct.getFields().forEach(f -> namesCollector.addName(f.getName()));
                varProc.refreshVarNames(namesCollector);
                if (DecompilerContext.getOption("udv") && (attr = mt.getLocalVariableAttr()) != null) {
                    varProc.setDebugVarNames(attr.getMapParamNames());
                    methodWrapper.getOrBuildGraph().iterateExprents(exprent -> {
                        List<Exprent> lst = exprent.getAllExprents(true);
                        lst.add(exprent);
                        lst.stream().filter(e -> e.type == 12).forEach(e -> {
                            VarExprent varExprent = (VarExprent)e;
                            String name = varExprent.getDebugName(mt);
                            if (name != null) {
                                varProc.setVarName(varExprent.getVarVersionPair(), name);
                            }
                        });
                        return 0;
                    });
                }
            }
            DecompilerContext.getLogger().endMethod();
        }
        DecompilerContext.getLogger().endClass();
    }

    private static void killThread(Thread thread) {
        thread.stop();
    }

    public MethodWrapper getMethodWrapper(String name, String descriptor) {
        return this.methods.getWithKey(InterpreterUtil.makeUniqueKey(name, descriptor));
    }

    public StructClass getClassStruct() {
        return this.classStruct;
    }

    public VBStyleCollection<MethodWrapper, String> getMethods() {
        return this.methods;
    }

    public Set<String> getHiddenMembers() {
        return this.hiddenMembers;
    }

    public VBStyleCollection<Exprent, String> getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public VBStyleCollection<Exprent, String> getDynamicFieldInitializers() {
        return this.dynamicFieldInitializers;
    }

    public String toString() {
        return this.classStruct.qualifiedName;
    }
}

