/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.stats.ClusterContainerStats;
import org.infinispan.stats.ContainerStats;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.stats.impl.SecurityActions;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
@MBean(objectName="ClusterContainerStats", description="General container statistics aggregated across the cluster.")
public class ClusterContainerStatsImpl
extends AbstractClusterStats
implements ClusterContainerStats {
    private static final Log log = LogFactory.getLog(ClusterContainerStatsImpl.class);
    private ClusterExecutor clusterExecutor;
    private EmbeddedCacheManager cacheManager;

    public ClusterContainerStatsImpl() {
        super(log);
    }

    @Inject
    public void init(EmbeddedCacheManager cacheManager, GlobalConfiguration configuration) {
        this.cacheManager = cacheManager;
        this.statisticsEnabled = configuration.statistics();
    }

    @Override
    public void start() {
        this.clusterExecutor = SecurityActions.getClusterExecutor(this.cacheManager);
    }

    @Override
    void updateStats() throws Exception {
        List<Map<String, Number>> memoryMap = this.statistics();
        for (String attr : LONG_ATTRIBUTES) {
            this.putLongAttributes(memoryMap, attr);
        }
    }

    private List<Map<String, Number>> statistics() throws Exception {
        List<Map<String, Number>> successfulResponseMaps = Collections.synchronizedList(new ArrayList());
        if (this.clusterExecutor != null) {
            CompletableFutures.await(this.clusterExecutor.submitConsumer(ignore -> ContainerStats.getLocalStatMaps(), (addr, stats, t) -> {
                if (t == null) {
                    successfulResponseMaps.add((Map<String, Number>)stats);
                }
            }));
        }
        return successfulResponseMaps;
    }

    @Override
    @ManagedAttribute(description="The maximum amount of free memory in bytes across the cluster JVMs", displayName="Cluster wide available memory.", clusterWide=true)
    public long getMemoryAvailable() {
        return this.getStatAsLong("memoryAvailable");
    }

    @Override
    @ManagedAttribute(description="The maximum amount of memory that JVMs across the cluster will attempt to utilise in bytes", displayName="Cluster wide max memory of JVMs", clusterWide=true)
    public long getMemoryMax() {
        return this.getStatAsLong("memoryMax");
    }

    @Override
    @ManagedAttribute(description="The total amount of memory in the JVMs across the cluster in bytes", displayName="Cluster wide total memory", clusterWide=true)
    public long getMemoryTotal() {
        return this.getStatAsLong("memoryTotal");
    }

    @Override
    @ManagedAttribute(description="The amount of memory used by JVMs across the cluster in bytes", displayName="Cluster wide memory utilisation", clusterWide=true)
    public long getMemoryUsed() {
        return this.getStatAsLong("memoryUsed");
    }
}

