/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.spi.NavigablePath;

public class SqmAliasedNodeRef
extends AbstractSqmExpression<Integer> {
    private final int position;
    private final NavigablePath navigablePath;

    public SqmAliasedNodeRef(int position, SqmExpressible<Integer> intType, NodeBuilder criteriaBuilder) {
        super(intType, criteriaBuilder);
        this.position = position;
        this.navigablePath = null;
    }

    public SqmAliasedNodeRef(int position, NavigablePath navigablePath, SqmExpressible<Integer> type, NodeBuilder criteriaBuilder) {
        super(type, criteriaBuilder);
        this.position = position;
        this.navigablePath = navigablePath;
    }

    private SqmAliasedNodeRef(SqmAliasedNodeRef original) {
        super(original.getNodeType(), original.nodeBuilder());
        this.position = original.position;
        this.navigablePath = original.navigablePath;
    }

    @Override
    public SqmAliasedNodeRef copy(SqmCopyContext context) {
        SqmAliasedNodeRef existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmAliasedNodeRef expression = context.registerCopy(this, new SqmAliasedNodeRef(this));
        this.copyTo(expression, context);
        return expression;
    }

    public int getPosition() {
        return this.position;
    }

    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        if (this.navigablePath == null) {
            sb.append(this.position);
        } else {
            sb.append(this.navigablePath.getLocalName());
        }
    }
}

