/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import org.apache.commons.vfs2.provider.sftp.Utils;

public class IdentityInfo
implements IdentityProvider {
    private final byte[] passphrase;
    private final File privateKey;
    private final File publicKey;

    public IdentityInfo(File privateKey) {
        this(privateKey, null, null);
    }

    public IdentityInfo(File privateKey, byte[] passphrase) {
        this(privateKey, null, passphrase);
    }

    public IdentityInfo(File privateKey, File publicKey, byte[] passphrase) {
        this.privateKey = this.getAbsoluteFile(privateKey);
        this.publicKey = this.getAbsoluteFile(publicKey);
        this.passphrase = Utils.clone(passphrase);
    }

    @Override
    public void addIdentity(JSch jsch) throws JSchException {
        jsch.addIdentity(this.getAbsolutePath(this.privateKey), this.getAbsolutePath(this.publicKey), this.passphrase);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdentityInfo)) {
            return false;
        }
        IdentityInfo other = (IdentityInfo)obj;
        return Arrays.equals(this.passphrase, other.passphrase) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.publicKey, other.publicKey);
    }

    private File getAbsoluteFile(File privateKey) {
        return privateKey != null ? privateKey.getAbsoluteFile() : null;
    }

    private String getAbsolutePath(File file) {
        return file != null ? file.getAbsolutePath() : null;
    }

    public byte[] getPassphrase() {
        return Utils.clone(this.passphrase);
    }

    @Deprecated
    public byte[] getPassPhrase() {
        return Utils.clone(this.passphrase);
    }

    public File getPrivateKey() {
        return this.privateKey;
    }

    public File getPublicKey() {
        return this.publicKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.passphrase);
        return 31 * result + Objects.hash(this.privateKey, this.publicKey);
    }
}

