/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.composite;

import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class CompositeUtils {
    private CompositeUtils() {
        throw new IllegalStateException("Can't instantiate a utility class");
    }

    public static List<String> getCompositeTypeList(Environment environment) {
        return ((CompositeConfig)Binder.get((Environment)environment).bind("spring.cloud.config.server", CompositeConfig.class).get()).getComposite().stream().map(map -> (String)map.get("type")).collect(Collectors.toList());
    }

    public static String getFactoryName(String type, ConfigurableListableBeanFactory beanFactory) {
        String[] factoryNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EnvironmentRepositoryFactory.class, (boolean)true, (boolean)false);
        return Arrays.stream(factoryNames).filter(n -> StringUtils.startsWithIgnoreCase((String)n, (String)type)).findFirst().orElse(null);
    }

    public static Type[] getEnvironmentRepositoryFactoryTypeParams(ConfigurableListableBeanFactory beanFactory, String factoryName) {
        Class<?> factoryClass = CompositeUtils.getFactoryClass(beanFactory, factoryName);
        return CompositeUtils.getEnvironmentRepositoryFactoryTypeParams(factoryClass);
    }

    public static Type[] getEnvironmentRepositoryFactoryTypeParams(Class<?> factoryClass) {
        Optional<AnnotatedType> annotatedFactoryType = Arrays.stream(factoryClass.getAnnotatedInterfaces()).filter(i -> {
            ParameterizedType parameterizedType = (ParameterizedType)i.getType();
            return parameterizedType.getRawType().equals(EnvironmentRepositoryFactory.class);
        }).findFirst();
        ParameterizedType factoryParameterizedType = (ParameterizedType)annotatedFactoryType.orElse(factoryClass.getAnnotatedSuperclass()).getType();
        return factoryParameterizedType.getActualTypeArguments();
    }

    public static Class<?> getFactoryClass(ConfigurableListableBeanFactory beanFactory, String factoryName) {
        Class<?> factoryClass;
        MethodMetadata methodMetadata = (MethodMetadata)beanFactory.getBeanDefinition(factoryName).getSource();
        Assert.notNull((Object)methodMetadata, (String)"Factory MethodMetadata cannot be null.");
        try {
            factoryClass = Class.forName(methodMetadata.getReturnTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return factoryClass;
    }

    static class CompositeConfig {
        List<Map<String, Object>> composite;

        CompositeConfig() {
        }

        public List<Map<String, Object>> getComposite() {
            return this.composite;
        }

        public void setComposite(List<Map<String, Object>> composite) {
            this.composite = composite;
        }
    }
}

