/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.macros.internal;

import com.vladsch.flexmark.ext.macros.MacroReference;
import com.vladsch.flexmark.parser.InlineParser;
import com.vladsch.flexmark.parser.InlineParserExtension;
import com.vladsch.flexmark.parser.InlineParserExtensionFactory;
import com.vladsch.flexmark.parser.LightInlineParser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacrosInlineParserExtension
implements InlineParserExtension {
    static Pattern MACRO_REFERENCE = Pattern.compile("<<<([\\w_-]+)>>>");
    static Pattern MACRO_REFERENCE_INTELLIJ = Pattern.compile("<<<([\u001f\\w_-]+)>>>");

    public MacrosInlineParserExtension(LightInlineParser inlineParser) {
    }

    public void finalizeDocument(@NotNull InlineParser inlineParser) {
    }

    public void finalizeBlock(@NotNull InlineParser inlineParser) {
    }

    public boolean parse(@NotNull LightInlineParser inlineParser) {
        BasedSequence match = inlineParser.match(inlineParser.getParsing().intellijDummyIdentifier ? MACRO_REFERENCE_INTELLIJ : MACRO_REFERENCE);
        if (match != null) {
            BasedSequence name = (BasedSequence)match.midSequence(3, -3);
            MacroReference macro = new MacroReference(match.subSequence(0, 3), name, (BasedSequence)match.midSequence(-3));
            inlineParser.flushTextNode();
            inlineParser.getBlock().appendChild((Node)macro);
            return true;
        }
        return false;
    }

    public static class Factory
    implements InlineParserExtensionFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @NotNull
        public CharSequence getCharacters() {
            return "<";
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        @NotNull
        public InlineParserExtension apply(@NotNull LightInlineParser lightInlineParser) {
            return new MacrosInlineParserExtension(lightInlineParser);
        }

        public boolean affectsGlobalScope() {
            return false;
        }
    }
}

