/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.SvnKitEnvironmentRepository;
import org.springframework.core.env.ConfigurableEnvironment;

public class SvnEnvironmentRepositoryFactory
implements EnvironmentRepositoryFactory<SvnKitEnvironmentRepository, SvnKitEnvironmentProperties> {
    private ConfigurableEnvironment environment;
    private ConfigServerProperties server;
    private final ObservationRegistry observationRegistry;

    public SvnEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties server, ObservationRegistry observationRegistry) {
        this.environment = environment;
        this.server = server;
        this.observationRegistry = observationRegistry;
    }

    @Override
    public SvnKitEnvironmentRepository build(SvnKitEnvironmentProperties environmentProperties) {
        SvnKitEnvironmentRepository repository = new SvnKitEnvironmentRepository(this.environment, environmentProperties, this.observationRegistry);
        if (this.server.getDefaultLabel() != null) {
            repository.setDefaultLabel(this.server.getDefaultLabel());
        }
        return repository;
    }
}

