/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ResizableMultiReaderRingBuffer$NothingToReadException$;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Me!B\u0013'\u0001)\u0002\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011u\u0002!\u0011!Q\u0001\niB\u0001B\u0010\u0001\u0003\u0006\u0004%\ta\u0010\u0005\n\u0003\u001b\u0001!\u0011!Q\u0001\n\u0001CaA\u0012\u0001\u0005\u0002\u0005=\u0001bBA\u0018\u0001\u0001\u0006IA\u000f\u0005\t\u0003c\u0001\u0001\u0015)\u0003\u00024!9\u0011\u0011\b\u0001!B\u0013Q\u0004bBA\u001e\u0001\u0001\u0006KA\u000f\u0005\u0007\u0003{\u0001A\u0011\u0002<\t\r\u0005}\u0002\u0001\"\u0003w\u0011\u0019\t\t\u0005\u0001C\u0001m\"9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA'\u0001\u0011\u0005\u0011Q\t\u0005\u0007\u0003\u001f\u0002A\u0011\u0001<\t\r\u0005E\u0003\u0001\"\u0001w\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002b\u0001!\t!a\u0019\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA;\u0001\u0011%\u0011q\u000f\u0005\b\u0003s\u0002A\u0011CA>\u0011\u001d\ti\b\u0001C!\u0003\u007f:aa\u0011\u0014\t\u0002)\"eAB\u0013'\u0011\u0003QS\tC\u0003G5\u0011\u0005qiB\u0003I5!\u0005\u0011JB\u0003L5!\u0005A\nC\u0003G;\u0011\u0005\u0011\rC\u0004c;\u0005\u0005I\u0011B2\u0007\u000f1T\u0002\u0013aI\u0001[\")a\b\tD\u0001]\u001a91O\u0007I\u0001$\u0003!\b\"B;#\r\u00031\b\"B<#\r\u0003A(A\b*fg&T\u0018M\u00197f\u001bVdG/\u001b*fC\u0012,'OU5oO\n+hMZ3s\u0015\t9\u0003&\u0001\u0003j[Bd'BA\u0015+\u0003\u0019\u0019HO]3b[*\u00111\u0006L\u0001\u0006a\u0016\\7n\u001c\u0006\u0003[9\na!\u00199bG\",'\"A\u0018\u0002\u0007=\u0014x-F\u00022\u0003/\u0019\"\u0001\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\r\u0005s\u0017PU3g\u0003-Ig.\u001b;jC2\u001c\u0016N_3\u0004\u0001A\u00111gO\u0005\u0003yQ\u00121!\u00138u\u0003\u001di\u0017\r_*ju\u0016\fqaY;sg>\u00148/F\u0001A!\t\t\u0005E\u0004\u0002C35\ta%\u0001\u0010SKNL'0\u00192mK6+H\u000e^5SK\u0006$WM\u001d*j]\u001e\u0014UO\u001a4feB\u0011!IG\n\u00035I\na\u0001P5oSRtD#\u0001#\u0002-9{G\u000f[5oOR{'+Z1e\u000bb\u001cW\r\u001d;j_:\u0004\"AS\u000f\u000e\u0003i\u0011aCT8uQ&tw\rV8SK\u0006$W\t_2faRLwN\\\n\u0004;5K\u0006C\u0001(W\u001d\tyEK\u0004\u0002Q'6\t\u0011K\u0003\u0002Ss\u00051AH]8pizJ\u0011!N\u0005\u0003+R\nq\u0001]1dW\u0006<W-\u0003\u0002X1\n\u0001\"+\u001e8uS6,W\t_2faRLwN\u001c\u0006\u0003+R\u0002\"AW0\u000e\u0003mS!\u0001X/\u0002\u000f\r|g\u000e\u001e:pY*\u0011a\fN\u0001\u0005kRLG.\u0003\u0002a7\naaj\\*uC\u000e\\GK]1dKR\t\u0011*\u0001\u0007xe&$XMU3qY\u0006\u001cW\rF\u0001e!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0003mC:<'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001a\u0014aa\u00142kK\u000e$(aB\"veN|'o]\n\u0003AI*\u0012a\u001c\t\u0004\u001dB\u0014\u0018BA9Y\u0005\u0011a\u0015n\u001d;\u0011\u0005)\u0013#AB\"veN|'o\u0005\u0002#e\u000511-\u001e:t_J,\u0012AO\u0001\u000bGV\u00148o\u001c:`I\u0015\fHCA=}!\t\u0019$0\u0003\u0002|i\t!QK\\5u\u0011\u0015iH\u00051\u0001;\u0003\tI\u0007\u0010\u000b\u0002\u001b\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006)\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI!a\u0001\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u00033}\f\u0001bY;sg>\u00148\u000f\t\u000b\t\u0003#\tI#a\u000b\u0002.A!!\tAA\n!\u0011\t)\"a\u0006\r\u0001\u00119\u0011\u0011\u0004\u0001C\u0002\u0005m!!\u0001+\u0012\t\u0005u\u00111\u0005\t\u0004g\u0005}\u0011bAA\u0011i\t9aj\u001c;iS:<\u0007cA\u001a\u0002&%\u0019\u0011q\u0005\u001b\u0003\u0007\u0005s\u0017\u0010C\u00039\u000b\u0001\u0007!\bC\u0003>\u000b\u0001\u0007!\bC\u0003?\u000b\u0001\u0007\u0001)\u0001\u0006nCb\u001c\u0016N_3CSR\fQ!\u0019:sCf\u0004RaMA\u001b\u0003GI1!a\u000e5\u0005\u0015\t%O]1z\u0003\u001d9(/\u001b;f\u0013b\faA]3bI&C\u0018A\u00027f]\nKG/\u0001\u0003nCN\\\u0017\u0001B:ju\u0016\fq![:F[B$\u00180\u0006\u0002\u0002HA\u00191'!\u0013\n\u0007\u0005-CGA\u0004C_>dW-\u00198\u0002\u00119|g.R7qif\fA#[7nK\u0012L\u0017\r^3ms\u00063\u0018-\u001b7bE2,\u0017\u0001D7bq\u00063\u0018-\u001b7bE2,\u0017!B2pk:$Hc\u0001\u001e\u0002X!1Q/\u0005a\u0001\u00033\u0002\"!\u0011\u0012\u0002\u0015%t\u0017\u000e^\"veN|'\u000fF\u0002z\u0003?Ba!\u001e\nA\u0002\u0005e\u0013!B<sSR,G\u0003BA$\u0003KBq!a\u001a\u0014\u0001\u0004\t\u0019\"A\u0003wC2,X-\u0001\u0003sK\u0006$G\u0003BA\n\u0003[Ba!\u001e\u000bA\u0002\u0005e\u0013aD8o\u0007V\u00148o\u001c:SK6|g/\u001a3\u0015\u0007e\f\u0019\b\u0003\u0004v+\u0001\u0007\u0011\u0011L\u0001\rkB$\u0017\r^3SK\u0006$\u0017\n\u001f\u000b\u0002s\u0006yQO\u001c3fe2L\u0018N\\4BeJ\f\u00170\u0006\u0002\u00024\u0005AAo\\*ue&tw\r\u0006\u0002\u0002\u0002B!\u00111QAF\u001d\u0011\t))a\"\u0011\u0005A#\u0014bAAEi\u00051\u0001K]3eK\u001aLA!!$\u0002\u0010\n11\u000b\u001e:j]\u001eT1!!#5Q\t\u0001q\u0010")
@InternalApi
public class ResizableMultiReaderRingBuffer<T> {
    private final Cursors cursors;
    private final int maxSizeBit;
    private Object[] array;
    private int writeIx;
    private int readIx;

    public Cursors cursors() {
        return this.cursors;
    }

    private int lenBit() {
        return Integer.numberOfTrailingZeros(this.array.length);
    }

    private int mask() {
        return Integer.MAX_VALUE >> 31 - this.lenBit();
    }

    public int size() {
        return this.writeIx - this.readIx;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int immediatelyAvailable() {
        return this.array.length - this.size();
    }

    public int maxAvailable() {
        return (1 << this.maxSizeBit) - this.size();
    }

    public int count(Cursor cursor) {
        return this.writeIx - cursor.cursor();
    }

    public void initCursor(Cursor cursor) {
        cursor.cursor_$eq(this.readIx);
    }

    public boolean write(T value) {
        if (this.size() < this.array.length) {
            this.array[this.writeIx & this.mask()] = value;
            ++this.writeIx;
            return true;
        }
        if (this.lenBit() < this.maxSizeBit) {
            int r = this.readIx & this.mask();
            Object[] newArray = new Object[this.array.length << 1];
            System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
            System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
            this.rebaseCursors$1(this.cursors().cursors());
            this.array = newArray;
            int w = this.size();
            this.array[w & this.mask()] = value;
            this.writeIx = w + 1;
            this.readIx = 0;
            return true;
        }
        return false;
    }

    public T read(Cursor cursor) {
        int c = cursor.cursor();
        if (c - this.writeIx < 0) {
            cursor.cursor_$eq(cursor.cursor() + 1);
            Object ret = this.array[c & this.mask()];
            if (c == this.readIx) {
                this.updateReadIx();
            }
            return (T)ret;
        }
        throw ResizableMultiReaderRingBuffer$NothingToReadException$.MODULE$;
    }

    public void onCursorRemoved(Cursor cursor) {
        if (cursor.cursor() == this.readIx) {
            this.updateReadIx();
            return;
        }
    }

    private void updateReadIx() {
        int newReadIx = this.writeIx + this.minCursor$1(this.cursors().cursors(), 0);
        while (this.readIx != newReadIx) {
            this.array[this.readIx & this.mask()] = null;
            ++this.readIx;
        }
    }

    public Object[] underlyingArray() {
        return this.array;
    }

    public String toString() {
        return new StringBuilder(66).append("ResizableMultiReaderRingBuffer(size=").append(this.size()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(", cursors=").append(this.cursors().cursors().size()).append(")").toString();
    }

    private final void rebaseCursors$1(List remaining) {
        while (remaining instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)remaining;
            Cursor head = (Cursor)colon2.head();
            List tail = colon2.next$access$1();
            head.cursor_$eq(head.cursor() - this.readIx);
            remaining = tail;
        }
    }

    private final int minCursor$1(List remaining, int result) {
        while (remaining instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)remaining;
            Cursor head = (Cursor)colon2.head();
            result = package$.MODULE$.min(head.cursor() - this.writeIx, result);
            remaining = colon2.next$access$1();
        }
        return result;
    }

    public ResizableMultiReaderRingBuffer(int initialSize, int maxSize, Cursors cursors) {
        this.cursors = cursors;
        Predef$.MODULE$.require(Integer.lowestOneBit(maxSize) == maxSize && 0 < maxSize && maxSize <= 0x3FFFFFFF, (Function0 & Serializable)() -> "maxSize must be a power of 2 that is > 0 and < Int.MaxValue/2");
        Predef$.MODULE$.require(Integer.lowestOneBit(initialSize) == initialSize && 0 < initialSize && initialSize <= maxSize, (Function0 & Serializable)() -> "initialSize must be a power of 2 that is > 0 and <= maxSize");
        this.maxSizeBit = Integer.numberOfTrailingZeros(maxSize);
        this.array = new Object[initialSize];
        this.writeIx = 0;
        this.readIx = 0;
    }

    public static interface Cursor {
        public int cursor();

        public void cursor_$eq(int var1);
    }

    public static interface Cursors {
        public List<Cursor> cursors();
    }
}

