/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public abstract class StepJsonConverter {
    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();

    public String toJson(StepState step) {
        JsonWriter writer = new JsonWriter();
        this.writeJson(step, writer);
        return writer.toString();
    }

    public JsonWriter writeJson(StepState step, JsonWriter writer) {
        StepExecutionState state = step.getState();
        writer.object();
        writer.key("state").value(state);
        writer.key("failures").value(step.getFailureCount());
        writer.key("skippable").value(step.getSkippable());
        writer.key("description").value(step.getDescription());
        if (step.getStartDate() != null) {
            writer.key("startDate").value(this.timeAdapter.marshal(step.getStartDate()));
        }
        if (step.getCompletionDate() != null) {
            writer.key("completionDate").value(this.timeAdapter.marshal(step.getCompletionDate()));
        }
        if (step.getLog() != null) {
            writer.key("log").value(step.getLog());
        }
        if (step.getPreviousAttemptsLogs() != null) {
            writer.key("previousAttemptsLogs");
            writer.array();
            step.getPreviousAttemptsLogs().forEach(writer::value);
            writer.endArray();
        }
        writer.endObject();
        return writer;
    }

    public StepState toStep(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            StepExecutionState state = StepExecutionState.valueOf((String)json.getString("state"));
            int failureCount = json.getInt("failures");
            String description = json.getString("description");
            boolean skippable = json.getBoolean("skippable");
            DateTime startDate = null;
            if (json.has("startDate")) {
                startDate = this.timeAdapter.unmarshal(json.getString("startDate"));
            }
            DateTime completionDate = null;
            if (json.has("completionDate")) {
                completionDate = this.timeAdapter.unmarshal(json.getString("completionDate"));
            }
            String log = null;
            if (json.has("log")) {
                log = json.getString("log");
            }
            ArrayList<String> prevLogs = null;
            if (json.has("previousAttemptsLogs")) {
                prevLogs = new ArrayList<String>();
                JSONArray jsonLogs = json.getJSONArray("previousAttemptsLogs");
                for (int i = 0; i < jsonLogs.length(); ++i) {
                    prevLogs.add(jsonLogs.getString(i));
                }
            }
            return this.createStepState(state, failureCount, description, startDate, completionDate, log, prevLogs, skippable);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }

    protected abstract StepState createStepState(StepExecutionState var1, int var2, String var3, DateTime var4, DateTime var5, String var6, List<String> var7, boolean var8);
}

