/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.dto.XLDAsCodeResult;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;

@XStreamProvider(readable=XLDAsCodeResult.class, tagName="xld-as-code-result")
public class XLDAsCodeResultConverter
implements Converter {
    public boolean canConvert(Class type) {
        return XLDAsCodeResult.class.isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        XLDAsCodeResult result = (XLDAsCodeResult)source;
        writer.startNode("success");
        writer.setValue(String.valueOf(result.isSuccess()));
        writer.endNode();
        if (result.getMessage() != null) {
            writer.startNode("message");
            writer.setValue(result.getMessage());
            writer.endNode();
        }
        if (result.getContent() != null) {
            writer.startNode("content");
            writer.setValue(result.getContent());
            writer.endNode();
        }
        if (result.getError() != null) {
            writer.startNode("error");
            writer.setValue(result.getError());
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        XLDAsCodeResult result = new XLDAsCodeResult();
        while (reader.hasMoreChildren()) {
            String nodeName;
            reader.moveDown();
            switch (nodeName = reader.getNodeName()) {
                case "success": {
                    result.setSuccess(Boolean.parseBoolean(reader.getValue()));
                    break;
                }
                case "message": {
                    result.setMessage(reader.getValue());
                    break;
                }
                case "content": {
                    result.setContent(reader.getValue());
                    break;
                }
                case "error": {
                    result.setError(reader.getValue());
                }
            }
            reader.moveUp();
        }
        return result;
    }
}

