/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.rendering;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.util.ByteArrayRendering;
import org.apache.pekko.http.impl.util.ByteStringRendering;
import org.apache.pekko.http.impl.util.EnhancedString$;
import org.apache.pekko.http.impl.util.Renderer;
import org.apache.pekko.http.impl.util.Renderer$RenderableRenderer$;
import org.apache.pekko.http.impl.util.Rendering;
import org.apache.pekko.http.impl.util.Rendering$CrLf$;
import org.apache.pekko.http.impl.util.Rendering$Empty$;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.ContentTypes$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$LastChunk$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.headers.Content$minusType$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.scaladsl.GraphDSL;
import org.apache.pekko.stream.scaladsl.GraphDSL$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.util.ByteString;
import org.parboiled2.CharUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.LinearSeq;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;

@InternalApi
public final class RenderSupport$ {
    public static final RenderSupport$ MODULE$;
    private static final byte[] DefaultStatusLineBytes;
    private static final byte[] StatusLineStartBytes;
    private static final byte[] ChunkedBytes;
    private static final byte[] KeepAliveBytes;
    private static final byte[] CloseBytes;
    private static final byte[] CrLf;
    private static final byte[] ContentLengthBytes;
    private static final byte[] ApplicationJsonContentType;
    private static final byte[] TextPlainContentType;
    private static final byte[] TextXmlContentType;
    private static final byte[] TextHtmlContentType;
    private static final byte[] TextCsvContentType;
    private static final Renderer<Iterable<HttpHeader>> trailerRenderer;
    private static final ByteString defaultLastChunkBytes;

    /*
     * WARNING - void declaration
     */
    static {
        void genericSeqRenderer_tRenderer;
        void genericSeqRenderer_sRenderer;
        MODULE$ = new RenderSupport$();
        DefaultStatusLineBytes = EnhancedString$.MODULE$.asciiBytes$extension("HTTP/1.1 200 OK\r\n");
        StatusLineStartBytes = EnhancedString$.MODULE$.asciiBytes$extension("HTTP/1.1 ");
        ChunkedBytes = EnhancedString$.MODULE$.asciiBytes$extension("chunked");
        KeepAliveBytes = EnhancedString$.MODULE$.asciiBytes$extension("Keep-Alive");
        CloseBytes = EnhancedString$.MODULE$.asciiBytes$extension("close");
        CrLf = EnhancedString$.MODULE$.asciiBytes$extension("\r\n");
        ContentLengthBytes = EnhancedString$.MODULE$.asciiBytes$extension("Content-Length: ");
        ApplicationJsonContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.application$divjson());
        TextPlainContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029());
        TextXmlContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029());
        TextHtmlContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029());
        TextCsvContentType = MODULE$.preRenderContentType(ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029());
        Renderer$RenderableRenderer$ renderer$RenderableRenderer$ = Renderer$RenderableRenderer$.MODULE$;
        Renderer$RenderableRenderer$ renderer$RenderableRenderer$2 = Renderer$RenderableRenderer$.MODULE$;
        Rendering$Empty$ genericSeqRenderer_empty = Rendering$Empty$.MODULE$;
        Rendering$CrLf$ genericSeqRenderer_separator = Rendering$CrLf$.MODULE$;
        Object var0_3 = null;
        Object var1_2 = null;
        renderer$RenderableRenderer$2 = null;
        renderer$RenderableRenderer$ = null;
        trailerRenderer = new Renderer<Iterable<T>>((Renderer)genericSeqRenderer_sRenderer, genericSeqRenderer_separator, (Renderer)genericSeqRenderer_tRenderer, genericSeqRenderer_empty){
            private final Renderer sRenderer$2;
            private final Object separator$1;
            private final Renderer tRenderer$2;
            private final Object empty$1;

            public <R extends Rendering> R render(R r, Iterable<T> value) {
                if (Nil$.MODULE$.equals(value)) {
                    return (R)r.$tilde$tilde((Object)this.empty$1, this.sRenderer$2);
                }
                if (value instanceof IndexedSeq) {
                    IndexedSeq indexedSeq = (IndexedSeq)value;
                    return (R)this.recI$1(indexedSeq, 0, r);
                }
                if (value instanceof LinearSeq) {
                    return (R)this.recL$1((LinearSeq)value, value, r);
                }
                throw new MatchError(value);
            }

            private final Rendering recI$1(IndexedSeq values, int ix, Rendering r$1) {
                while (ix < values.size()) {
                    if (ix > 0) {
                        this.sRenderer$2.render(r$1, this.separator$1);
                    }
                    this.tRenderer$2.render(r$1, values.apply(ix));
                    ++ix;
                }
                return r$1;
            }

            private static final int recI$default$2$1() {
                return 0;
            }

            private final Rendering recL$1(LinearSeq remaining, Iterable value$1, Rendering r$1) {
                while (remaining.nonEmpty()) {
                    if (remaining != value$1) {
                        this.sRenderer$2.render(r$1, this.separator$1);
                    }
                    this.tRenderer$2.render(r$1, remaining.head());
                    remaining = (LinearSeq)remaining.tail();
                }
                return r$1;
            }
            {
                this.sRenderer$2 = sRenderer$2;
                this.separator$1 = separator$1;
                this.tRenderer$2 = tRenderer$2;
                this.empty$1 = empty$1;
            }
        };
        defaultLastChunkBytes = MODULE$.org$apache$pekko$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity$LastChunk$.MODULE$);
    }

    public byte[] DefaultStatusLineBytes() {
        return DefaultStatusLineBytes;
    }

    public byte[] StatusLineStartBytes() {
        return StatusLineStartBytes;
    }

    public byte[] ChunkedBytes() {
        return ChunkedBytes;
    }

    public byte[] KeepAliveBytes() {
        return KeepAliveBytes;
    }

    public byte[] CloseBytes() {
        return CloseBytes;
    }

    public byte[] CrLf() {
        return CrLf;
    }

    public byte[] ContentLengthBytes() {
        return ContentLengthBytes;
    }

    private byte[] preRenderContentType(ContentType ct) {
        return ((ByteArrayRendering)new ByteArrayRendering(64).$tilde$tilde(Content$minusType$.MODULE$, Renderer$RenderableRenderer$.MODULE$).$tilde$tilde(ct, Renderer$RenderableRenderer$.MODULE$)).$tilde$tilde(this.CrLf()).get();
    }

    private byte[] ApplicationJsonContentType() {
        return ApplicationJsonContentType;
    }

    private byte[] TextPlainContentType() {
        return TextPlainContentType;
    }

    private byte[] TextXmlContentType() {
        return TextXmlContentType;
    }

    private byte[] TextHtmlContentType() {
        return TextHtmlContentType;
    }

    private byte[] TextCsvContentType() {
        return TextCsvContentType;
    }

    public Renderer<Iterable<HttpHeader>> trailerRenderer() {
        return trailerRenderer;
    }

    public ByteString defaultLastChunkBytes() {
        return defaultLastChunkBytes;
    }

    public <T, Mat> Source<T, Mat> CancelSecond(Source<T, Mat> first, Source<T, Object> second) {
        return Source$.MODULE$.fromGraph(GraphDSL$.MODULE$.createGraph(first, (Function1 & Serializable)b -> (Function1 & Serializable)frst -> {
            new GraphDSL.Implicits$.SourceArrow(GraphDSL.Implicits$.MODULE$.SourceArrow((Graph)second)).$tilde$greater((Graph)Sink$.MODULE$.cancelled(), b);
            return new SourceShape(frst.out());
        }));
    }

    public Rendering renderEntityContentType(Rendering r, HttpEntity entity) {
        ContentType ct = entity.contentType();
        if (ct == ContentTypes$.MODULE$.NoContentType()) {
            return r;
        }
        if (ct == ContentTypes$.MODULE$.application$divjson()) {
            return r.$tilde$tilde(this.ApplicationJsonContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextPlainContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divxml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextXmlContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divhtml$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextHtmlContentType());
        }
        if (ct == ContentTypes$.MODULE$.text$divcsv$u0028UTF$minus8$u0029()) {
            return r.$tilde$tilde(this.TextCsvContentType());
        }
        return r.$tilde$tilde(Content$minusType$.MODULE$, Renderer$RenderableRenderer$.MODULE$).$tilde$tilde(ct, Renderer$RenderableRenderer$.MODULE$).$tilde$tilde(this.CrLf());
    }

    public ByteString org$apache$pekko$http$impl$engine$rendering$RenderSupport$$renderChunk(HttpEntity.ChunkStreamPart chunk) {
        ByteStringRendering r;
        block7: {
            HttpEntity.LastChunk lastChunk;
            boolean bl;
            block8: {
                block6: {
                    int renderedSize = CharUtils$.MODULE$.numberOfHexDigits((long)chunk.data().length()) + (chunk.extension().isEmpty() ? 0 : chunk.extension().length() + 1) + chunk.data().length() + 2 + 2;
                    r = new ByteStringRendering(renderedSize);
                    r.$tilde$tilde$percent(chunk.data().length());
                    if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(chunk.extension()))) {
                        r.$tilde$tilde(';').$tilde$tilde(chunk.extension());
                    }
                    r.$tilde$tilde(this.CrLf());
                    bl = false;
                    lastChunk = null;
                    if (!(chunk instanceof HttpEntity.Chunk)) break block6;
                    ByteString data = ((HttpEntity.Chunk)chunk).data();
                    r.$tilde$tilde(data);
                    break block7;
                }
                if (!(chunk instanceof HttpEntity.LastChunk)) break block8;
                bl = true;
                lastChunk = (HttpEntity.LastChunk)chunk;
                Seq<HttpHeader> seq = lastChunk.trailer();
                if (Nil$.MODULE$.equals(seq)) break block7;
            }
            if (bl) {
                Seq<HttpHeader> trailer = lastChunk.trailer();
                ((ByteStringRendering)r.$tilde$tilde(trailer, this.trailerRenderer())).$tilde$tilde(this.CrLf());
            } else {
                throw new MatchError((Object)chunk);
            }
        }
        r.$tilde$tilde(this.CrLf());
        return r.get();
    }

    public void suppressionWarning(LoggingAdapter log, HttpHeader h, String msg) {
        log.warning("Explicitly set HTTP header '{}' is ignored, {}", (Object)h, (Object)msg);
    }

    public String suppressionWarning$default$3() {
        return "the pekko-http-core layer sets this header automatically!";
    }

    private RenderSupport$() {
    }
}

