/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.server.ServerProducer;

public class ServerProducerImpl
implements ServerProducer {
    private static final AtomicLong PRODUCER_ID_GENERATOR = new AtomicLong();
    private final long ID = PRODUCER_ID_GENERATOR.incrementAndGet();
    private final String name;
    private final String protocol;
    private final long creationTime;
    private volatile long messagesSent = 0L;
    private volatile long messagesSentSize = 0L;
    private static final AtomicLongFieldUpdater<ServerProducerImpl> messagesSentUpdater = AtomicLongFieldUpdater.newUpdater(ServerProducerImpl.class, "messagesSent");
    private static final AtomicLongFieldUpdater<ServerProducerImpl> messagesSentSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerProducerImpl.class, "messagesSentSize");
    private final String address;
    private volatile Object lastProducedMessageID;
    private String sessionID;
    private String connectionID;

    public ServerProducerImpl(String name, String protocol, String address) {
        this.name = name;
        this.protocol = protocol;
        this.address = address;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long getID() {
        return this.ID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public void setConnectionID(String connectionID) {
        this.connectionID = connectionID;
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public String getConnectionID() {
        return this.connectionID;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void updateMetrics(Object lastProducedMessageID, int encodeSize) {
        messagesSentUpdater.addAndGet(this, 1L);
        messagesSentSizeUpdater.getAndAdd(this, encodeSize);
        this.lastProducedMessageID = lastProducedMessageID;
    }

    @Override
    public Object getLastProducedMessageID() {
        return this.lastProducedMessageID;
    }

    @Override
    public long getMessagesSent() {
        return this.messagesSent;
    }

    @Override
    public long getMessagesSentSize() {
        return this.messagesSentSize;
    }
}

