/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;

public final class AMQPFederationAddressPolicyElement
implements Serializable {
    private static final long serialVersionUID = -5205164803216061323L;
    private final Set<AddressMatch> includes = new HashSet<AddressMatch>();
    private final Set<AddressMatch> excludes = new HashSet<AddressMatch>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private String name;
    private Boolean autoDelete;
    private Long autoDeleteDelay;
    private Long autoDeleteMessageCount;
    private int maxHops;
    private Boolean enableDivertBindings;
    private TransformerConfiguration transformerConfig;

    public String getName() {
        return this.name;
    }

    public AMQPFederationAddressPolicyElement setName(String name) {
        this.name = name;
        return this;
    }

    public Set<AddressMatch> getIncludes() {
        return this.includes;
    }

    public AMQPFederationAddressPolicyElement addToIncludes(String include) {
        this.includes.add(new AddressMatch().setAddressMatch(include));
        return this;
    }

    public AMQPFederationAddressPolicyElement addInclude(AddressMatch include) {
        this.includes.add(include);
        return this;
    }

    public AMQPFederationAddressPolicyElement setIncludes(Set<AddressMatch> includes) {
        this.includes.clear();
        if (includes != null) {
            this.includes.addAll(includes);
        }
        return this;
    }

    public Set<AddressMatch> getExcludes() {
        return this.excludes;
    }

    public AMQPFederationAddressPolicyElement addToExcludes(String exclude) {
        this.excludes.add(new AddressMatch().setAddressMatch(exclude));
        return this;
    }

    public AMQPFederationAddressPolicyElement addExclude(AddressMatch exclude) {
        this.excludes.add(exclude);
        return this;
    }

    public AMQPFederationAddressPolicyElement setExcludes(Set<AddressMatch> excludes) {
        this.excludes.clear();
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
        return this;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public AMQPFederationAddressPolicyElement addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPFederationAddressPolicyElement addProperty(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    public AMQPFederationAddressPolicyElement setProperties(Map<String, Object> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
        return this;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public AMQPFederationAddressPolicyElement setMaxHops(int maxHops) {
        this.maxHops = maxHops;
        return this;
    }

    public Long getAutoDeleteMessageCount() {
        return this.autoDeleteMessageCount;
    }

    public AMQPFederationAddressPolicyElement setAutoDeleteMessageCount(Long autoDeleteMessageCount) {
        this.autoDeleteMessageCount = autoDeleteMessageCount;
        return this;
    }

    public Long getAutoDeleteDelay() {
        return this.autoDeleteDelay;
    }

    public AMQPFederationAddressPolicyElement setAutoDeleteDelay(Long autoDeleteDelay) {
        this.autoDeleteDelay = autoDeleteDelay;
        return this;
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public AMQPFederationAddressPolicyElement setAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return this;
    }

    public Boolean isEnableDivertBindings() {
        return this.enableDivertBindings;
    }

    public AMQPFederationAddressPolicyElement setEnableDivertBindings(Boolean enableDivertBindings) {
        this.enableDivertBindings = enableDivertBindings;
        return this;
    }

    public AMQPFederationAddressPolicyElement setTransformerConfiguration(TransformerConfiguration transformerConfig) {
        this.transformerConfig = transformerConfig;
        return this;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AMQPFederationAddressPolicyElement)) {
            return false;
        }
        AMQPFederationAddressPolicyElement that = (AMQPFederationAddressPolicyElement)o;
        return this.maxHops == that.maxHops && Objects.equals(this.name, that.name) && Objects.equals(this.includes, that.includes) && Objects.equals(this.excludes, that.excludes) && Objects.equals(this.autoDelete, that.autoDelete) && Objects.equals(this.autoDeleteDelay, that.autoDeleteDelay) && Objects.equals(this.autoDeleteMessageCount, that.autoDeleteMessageCount);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includes, this.excludes, this.autoDelete, this.autoDeleteDelay, this.autoDeleteMessageCount, this.maxHops);
    }

    public static class AddressMatch
    implements Serializable {
        private static final long serialVersionUID = 8517154638045698017L;
        private String name;
        private String addressMatch;

        public String getName() {
            return this.name;
        }

        public AddressMatch setName(String name) {
            this.name = name;
            return this;
        }

        public String getAddressMatch() {
            return this.addressMatch;
        }

        public AddressMatch setAddressMatch(String addressMatch) {
            this.addressMatch = addressMatch;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddressMatch)) {
                return false;
            }
            AddressMatch matcher = (AddressMatch)o;
            return Objects.equals(this.addressMatch, matcher.addressMatch);
        }

        public int hashCode() {
            return Objects.hash(this.addressMatch, this.addressMatch);
        }
    }
}

