/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.Arrays;
import java.util.Collection;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class Ifconfig
extends SigarCommandBase {
    public Ifconfig(Shell shell) {
        super(shell);
    }

    public Ifconfig() {
    }

    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    public String getSyntaxArgs() {
        return "[interface]";
    }

    public String getUsageShort() {
        return "Network interface information";
    }

    public Collection getCompletions() {
        String[] ifNames;
        try {
            ifNames = this.proxy.getNetInterfaceList();
        }
        catch (SigarException e) {
            return super.getCompletions();
        }
        return Arrays.asList(ifNames);
    }

    public void output(String[] args) throws SigarException {
        String[] ifNames = args.length == 1 ? args : this.proxy.getNetInterfaceList();
        for (int i = 0; i < ifNames.length; ++i) {
            try {
                this.output(ifNames[i]);
                continue;
            }
            catch (SigarException e) {
                this.println(ifNames[i] + "\t" + e.getMessage());
            }
        }
    }

    public void output(String name) throws SigarException {
        NetInterfaceConfig ifconfig = this.sigar.getNetInterfaceConfig(name);
        long flags = ifconfig.getFlags();
        String hwaddr = "";
        if (!"00:00:00:00:00:00".equals(ifconfig.getHwaddr())) {
            hwaddr = " HWaddr " + ifconfig.getHwaddr();
        }
        if (!ifconfig.getName().equals(ifconfig.getDescription())) {
            this.println(ifconfig.getDescription());
        }
        this.println(ifconfig.getName() + "\t" + "Link encap:" + ifconfig.getType() + hwaddr);
        String ptp = "";
        if ((flags & 0x10L) > 0L) {
            ptp = "  P-t-P:" + ifconfig.getDestination();
        }
        String bcast = "";
        if ((flags & 2L) > 0L) {
            bcast = "  Bcast:" + ifconfig.getBroadcast();
        }
        this.println("\tinet addr:" + ifconfig.getAddress() + ptp + bcast + "  Mask:" + ifconfig.getNetmask());
        this.println("\t" + NetFlags.getIfFlagsString(flags) + " MTU:" + ifconfig.getMtu() + "  Metric:" + ifconfig.getMetric());
        try {
            NetInterfaceStat ifstat = this.sigar.getNetInterfaceStat(name);
            this.println("\tRX packets:" + ifstat.getRxPackets() + " errors:" + ifstat.getRxErrors() + " dropped:" + ifstat.getRxDropped() + " overruns:" + ifstat.getRxOverruns() + " frame:" + ifstat.getRxFrame());
            this.println("\tTX packets:" + ifstat.getTxPackets() + " errors:" + ifstat.getTxErrors() + " dropped:" + ifstat.getTxDropped() + " overruns:" + ifstat.getTxOverruns() + " carrier:" + ifstat.getTxCarrier());
            this.println("\tcollisions:" + ifstat.getTxCollisions());
            long rxBytes = ifstat.getRxBytes();
            long txBytes = ifstat.getTxBytes();
            this.println("\tRX bytes:" + rxBytes + " (" + Sigar.formatSize(rxBytes) + ")" + "  " + "TX bytes:" + txBytes + " (" + Sigar.formatSize(txBytes) + ")");
        }
        catch (SigarException e) {
            // empty catch block
        }
        this.println("");
    }

    public static void main(String[] args) throws Exception {
        new Ifconfig().processCommand(args);
    }
}

