/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheResolver;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.infinispan.cdi.common.util.BeanManagerProvider;
import org.infinispan.cdi.embedded.InfinispanExtensionEmbedded;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.jcache.annotation.Contracts;
import org.infinispan.jcache.annotation.DefaultCacheResolver;
import org.infinispan.jcache.annotation.InjectedCacheResolverQualifier;
import org.infinispan.jcache.embedded.JCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@InjectedCacheResolverQualifier
@ApplicationScoped
public class InjectedCacheResolver
implements CacheResolver {
    private static final Log log = LogFactory.getLog(DefaultCacheResolver.class);
    private EmbeddedCacheManager defaultCacheManager;
    private final Map<EmbeddedCacheManager, JCacheManager> jcacheManagers = new HashMap<EmbeddedCacheManager, JCacheManager>();
    private JCacheManager defaultJCacheManager;

    public InjectedCacheResolver() {
    }

    @Inject
    public InjectedCacheResolver(InfinispanExtensionEmbedded extension, BeanManager beanManager) {
        Set installedCacheManagers = extension.getInstalledEmbeddedCacheManagers(beanManager);
        for (InfinispanExtensionEmbedded.InstalledCacheManager installedCacheManager : installedCacheManagers) {
            JCacheManager jcacheManager = this.toJCacheManager(installedCacheManager.getCacheManager());
            this.jcacheManagers.put(installedCacheManager.getCacheManager(), jcacheManager);
        }
        this.initializeDefaultCacheManagers();
    }

    private void initializeDefaultCacheManagers() {
        this.defaultCacheManager = this.getBeanReference(EmbeddedCacheManager.class);
        if (this.jcacheManagers.containsKey(this.defaultCacheManager)) {
            this.defaultJCacheManager = this.jcacheManagers.get(this.defaultCacheManager);
        } else {
            this.defaultJCacheManager = this.toJCacheManager(this.defaultCacheManager);
            this.jcacheManagers.put(this.defaultCacheManager, this.defaultJCacheManager);
        }
    }

    private JCacheManager toJCacheManager(EmbeddedCacheManager cacheManager) {
        GlobalConfiguration globalCfg = cacheManager.getCacheManagerConfiguration();
        String name = globalCfg.cacheManagerName();
        return new JCacheManager(URI.create(name), cacheManager, Caching.getCachingProvider());
    }

    public <K, V> Cache<K, V> resolveCache(CacheInvocationContext<? extends Annotation> cacheInvocationContext) {
        Contracts.assertNotNull(cacheInvocationContext, "cacheInvocationContext parameter must not be null");
        String cacheName = cacheInvocationContext.getCacheName();
        if (cacheName.trim().isEmpty()) {
            if (log.isTraceEnabled()) {
                log.tracef("Resolved cache %s on %s", (Object)cacheName, (Object)this.defaultJCacheManager.getURI());
            }
            return this.getCacheFromDefaultCacheManager(cacheName);
        }
        for (EmbeddedCacheManager cm : this.jcacheManagers.keySet()) {
            Set cacheNames = cm.getCacheNames();
            for (String name : cacheNames) {
                if (!name.equals(cacheName)) continue;
                JCacheManager jcacheManager = this.jcacheManagers.get(cm);
                Cache cache = jcacheManager.getCache(cacheName);
                if (cache != null) {
                    return cache;
                }
                if (log.isTraceEnabled()) {
                    log.tracef("Resolved cache %s on %s", (Object)cacheName, (Object)jcacheManager.getURI());
                }
                return jcacheManager.getOrCreateCache(cacheName, (BasicCache)cm.getCache(cacheName).getAdvancedCache());
            }
        }
        return this.getCacheFromDefaultCacheManager(cacheName);
    }

    private <K, V> Cache<K, V> getCacheFromDefaultCacheManager(String cacheName) {
        Configuration defaultInjectedConfiguration = this.getBeanReference(Configuration.class);
        this.defaultCacheManager.defineConfiguration(cacheName, defaultInjectedConfiguration);
        return this.defaultJCacheManager.getOrCreateCache(cacheName, (BasicCache)this.defaultCacheManager.getCache(cacheName).getAdvancedCache());
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    private <T> T getBeanReference(Class<T> beanType) {
        BeanManager bm = this.getBeanManager();
        Iterator iterator = bm.getBeans(beanType, new Annotation[0]).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Default bean of type %s not found.", beanType.getName()));
        }
        Bean configurationBean = (Bean)iterator.next();
        CreationalContext createCreationalContext = bm.createCreationalContext((Contextual)configurationBean);
        return (T)bm.getReference(configurationBean, beanType, createCreationalContext);
    }
}

