/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.processors.FlowableProcessor;
import io.reactivex.rxjava3.processors.UnicastProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.executors.LimitedExecutor;
import org.infinispan.persistence.sifs.Compactor;
import org.infinispan.persistence.sifs.EntryInfo;
import org.infinispan.persistence.sifs.EntryPosition;
import org.infinispan.persistence.sifs.EntryRecord;
import org.infinispan.persistence.sifs.FileProvider;
import org.infinispan.persistence.sifs.IndexNode;
import org.infinispan.persistence.sifs.IndexRequest;
import org.infinispan.persistence.sifs.Log;
import org.infinispan.persistence.sifs.TemporaryTable;
import org.infinispan.util.concurrent.NonBlockingManager;

class Index {
    private static final Log log = Log.getLog(Index.class);
    private static final int GRACEFULLY = 1361759986;
    private static final int DIRTY = -787319028;
    private static final int INDEX_FILE_HEADER_SIZE = 34;
    private final NonBlockingManager nonBlockingManager;
    private final FileProvider dataFileProvider;
    private final FileProvider indexFileProvider;
    private final Path indexDir;
    private final Compactor compactor;
    private final int minNodeSize;
    private final int maxNodeSize;
    private final StampedLock lock = new StampedLock();
    @GuardedBy(value="lock")
    private final Segment[] segments;
    @GuardedBy(value="lock")
    private final FlowableProcessor<IndexRequest>[] flowableProcessors;
    private final TimeService timeService;
    private final File indexSizeFile;
    public final AtomicLongArray sizePerSegment;
    private final TemporaryTable temporaryTable;
    private final Executor executor;
    private final Segment emptySegment;
    private final FlowableProcessor<IndexRequest> emptyFlowable;
    private long maxSeqId = -1L;
    @GuardedBy(value="lock")
    private CompletionStage<Void> removeSegmentsStage = CompletableFutures.completedNull();
    private final IndexNode.OverwriteHook movedHook = new IndexNode.OverwriteHook(){

        @Override
        public boolean check(IndexRequest request, int oldFile, int oldOffset) {
            return (long)oldFile == request.getPrevFile() && oldOffset == request.getPrevOffset();
        }

        @Override
        public void setOverwritten(IndexRequest request, int cacheSegment, boolean overwritten, int prevFile, int prevOffset) {
            if (overwritten && request.getOffset() < 0 && request.getPrevOffset() >= 0) {
                Index.this.sizePerSegment.decrementAndGet(cacheSegment);
            }
        }
    };
    private final IndexNode.OverwriteHook updateHook = new IndexNode.OverwriteHook(){

        @Override
        public void setOverwritten(IndexRequest request, int cacheSegment, boolean overwritten, int prevFile, int prevOffset) {
            Index.this.nonBlockingManager.complete(request, overwritten);
            if (request.getOffset() >= 0 && prevOffset < 0) {
                Index.this.sizePerSegment.incrementAndGet(cacheSegment);
            } else if (request.getOffset() < 0 && prevOffset >= 0) {
                Index.this.sizePerSegment.decrementAndGet(cacheSegment);
            }
        }
    };
    private final IndexNode.OverwriteHook droppedHook = new IndexNode.OverwriteHook(){

        @Override
        public void setOverwritten(IndexRequest request, int cacheSegment, boolean overwritten, int prevFile, int prevOffset) {
            if (request.getPrevFile() == (long)prevFile && request.getPrevOffset() == prevOffset) {
                Index.this.sizePerSegment.decrementAndGet(cacheSegment);
            }
        }
    };

    public Index(NonBlockingManager nonBlockingManager, FileProvider dataFileProvider, Path indexDir, int cacheSegments, int minNodeSize, int maxNodeSize, TemporaryTable temporaryTable, Compactor compactor, TimeService timeService, Executor executor, int maxOpenFiles) throws IOException {
        this.nonBlockingManager = nonBlockingManager;
        this.dataFileProvider = dataFileProvider;
        this.compactor = compactor;
        this.timeService = timeService;
        this.indexDir = indexDir;
        this.minNodeSize = minNodeSize;
        this.maxNodeSize = maxNodeSize;
        this.sizePerSegment = new AtomicLongArray(cacheSegments);
        this.indexFileProvider = new FileProvider(indexDir, maxOpenFiles, "index.", Integer.MAX_VALUE);
        this.indexSizeFile = new File(indexDir.toFile(), "index-count");
        this.segments = new Segment[cacheSegments];
        this.flowableProcessors = new FlowableProcessor[cacheSegments];
        this.temporaryTable = temporaryTable;
        int concurrency = Math.max(cacheSegments >> 4, 1);
        this.executor = new LimitedExecutor("sifs-index", executor, concurrency);
        this.emptySegment = new Segment(this, -1, temporaryTable);
        this.emptySegment.complete(null);
        this.emptyFlowable = UnicastProcessor.create().toSerialized();
        this.emptyFlowable.subscribe(this::handleNonOwnedIndexRequest, log::fatalIndexError);
    }

    private void handleNonOwnedIndexRequest(IndexRequest ir) {
        switch (ir.getType()) {
            case UPDATE: 
            case MOVED: {
                this.compactor.free(ir.getFile(), ir.getSize());
                break;
            }
            case FOUND_OLD: {
                throw new IllegalStateException("This is only possible when building the index");
            }
            case SYNC_REQUEST: {
                Runnable runnable = (Runnable)ir.getKey();
                runnable.run();
                break;
            }
        }
        ir.complete(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkForExistingIndexSizeFile() {
        boolean validCount;
        block14: {
            int cacheSegments = this.sizePerSegment.length();
            validCount = false;
            try {
                RandomAccessFile indexCount = new RandomAccessFile(this.indexSizeFile, "r");
                int cacheSegmentsCount = UnsignedNumeric.readUnsignedInt((DataInput)indexCount);
                if (cacheSegmentsCount == cacheSegments) {
                } else {
                    log.tracef("Previous index file cache segments " + cacheSegmentsCount + " doesn't match configured cache segments " + cacheSegments, new Object[0]);
                    break block14;
                }
                finally {
                    indexCount.close();
                    for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                        long value = UnsignedNumeric.readUnsignedLong((DataInput)indexCount);
                        if (value < 0L) {
                            log.tracef("Found an invalid size for a segment, assuming index is a different format", new Object[0]);
                            boolean bl = false;
                            return bl;
                        }
                        this.sizePerSegment.set(i, value);
                    }
                    try {
                        this.maxSeqId = UnsignedNumeric.readUnsignedLong((DataInput)indexCount);
                    }
                    catch (EOFException e) {
                        log.tracef("Index didn't contain sequence id, will need to calculate, still retaining index", new Object[0]);
                    }
                    validCount = true;
                }
            }
            catch (IOException e) {
                log.tracef("Encountered IOException %s while reading index count file, assuming index dirty", e.getMessage());
            }
        }
        this.indexSizeFile.delete();
        return validCount;
    }

    public static byte[] toIndexKey(ByteBuffer buffer) {
        return Index.toIndexKey(buffer.getBuf(), buffer.getOffset(), buffer.getLength());
    }

    static byte[] toIndexKey(byte[] bytes, int offset, int length) {
        if (offset == 0 && length == bytes.length) {
            return bytes;
        }
        byte[] indexKey = new byte[length];
        System.arraycopy(bytes, 0, indexKey, 0, length);
        return indexKey;
    }

    public boolean load() {
        boolean loaded = this.attemptLoad();
        if (!loaded) {
            this.maxSeqId = -1L;
            this.compactor.getFileStats().clear();
            for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                this.sizePerSegment.set(i, 0L);
            }
        }
        return loaded;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean attemptLoad() {
        if (!this.checkForExistingIndexSizeFile()) {
            return false;
        }
        try {
            File statsFile = new File(this.indexDir.toFile(), "index.stats");
            if (!statsFile.exists()) {
                return false;
            }
            try (FileChannel statsChannel = new RandomAccessFile(statsFile, "rw").getChannel();){
                java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(20);
                while (Index.read(statsChannel, buffer)) {
                    buffer.flip();
                    int id = buffer.getInt();
                    int length = buffer.getInt();
                    int free = buffer.getInt();
                    long expirationTime = buffer.getLong();
                    if (!this.compactor.addFreeFile(id, length, free, expirationTime, false)) {
                        log.tracef("Unable to add free file: %s ", id);
                        boolean bl = false;
                        return bl;
                    }
                    log.tracef("Loading file info for file: %s with total: %s, free: %s", id, length, free);
                    buffer.flip();
                }
            }
            statsFile.delete();
            Segment[] segmentArray = this.segments;
            int n = segmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Segment segment = segmentArray[n2];
                if (!segment.load()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        catch (IOException e) {
            log.trace("Exception encountered while attempting to load index, assuming index is bad", e);
            return false;
        }
    }

    public void reset() throws IOException {
        for (Segment segment : this.segments) {
            segment.reset();
        }
    }

    public EntryRecord getRecord(Object key, int cacheSegment, ByteBuffer serializedKey) throws IOException {
        return this.getRecord(key, cacheSegment, Index.toIndexKey(serializedKey), IndexNode.ReadOperation.GET_RECORD);
    }

    public EntryRecord getRecordEvenIfExpired(Object key, int cacheSegment, byte[] serializedKey) throws IOException {
        return this.getRecord(key, cacheSegment, serializedKey, IndexNode.ReadOperation.GET_EXPIRED_RECORD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryRecord getRecord(Object key, int cacheSegment, byte[] indexKey, IndexNode.ReadOperation readOperation) throws IOException {
        long stamp = this.lock.readLock();
        try {
            EntryRecord entryRecord = (EntryRecord)IndexNode.applyOnLeaf(this.segments[cacheSegment], cacheSegment, indexKey, this.segments[cacheSegment].rootReadLock(), readOperation);
            return entryRecord;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPosition getPosition(Object key, int cacheSegment, ByteBuffer serializedKey) throws IOException {
        long stamp = this.lock.readLock();
        try {
            EntryPosition entryPosition = (EntryPosition)IndexNode.applyOnLeaf(this.segments[cacheSegment], cacheSegment, Index.toIndexKey(serializedKey), this.segments[cacheSegment].rootReadLock(), IndexNode.ReadOperation.GET_POSITION);
            return entryPosition;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryInfo getInfo(Object key, int cacheSegment, byte[] serializedKey) throws IOException {
        long stamp = this.lock.readLock();
        try {
            EntryInfo entryInfo = (EntryInfo)IndexNode.applyOnLeaf(this.segments[cacheSegment], cacheSegment, serializedKey, this.segments[cacheSegment].rootReadLock(), IndexNode.ReadOperation.GET_INFO);
            return entryInfo;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public CompletionStage<Void> clear() {
        log.tracef("Clearing index", new Object[0]);
        long stamp = this.lock.tryWriteLock();
        if (stamp != 0L) {
            return this.actualSubmitClear(stamp);
        }
        return CompletableFuture.supplyAsync(() -> {
            long innerStamp = this.lock.writeLock();
            return this.actualSubmitClear(innerStamp);
        }, this.executor).thenCompose(Function.identity());
    }

    private CompletionStage<Void> actualSubmitClear(long writeStampToUnlock) {
        try {
            AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
            for (FlowableProcessor<IndexRequest> processor : this.flowableProcessors) {
                if (processor == this.emptyFlowable) continue;
                IndexRequest clearRequest = IndexRequest.clearRequest();
                processor.onNext((Object)clearRequest);
                stage.dependsOn((CompletionStage)clearRequest);
            }
            return stage.freeze().whenComplete((ignore, t) -> {
                if (t != null) {
                    log.clearError((Throwable)t);
                } else {
                    log.tracef("Clear has completed", new Object[0]);
                    for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                        this.sizePerSegment.set(i, 0L);
                    }
                }
                this.lock.unlockWrite(writeStampToUnlock);
            });
        }
        catch (Throwable t2) {
            this.lock.unlockWrite(writeStampToUnlock);
            log.debugf(t2, "Clear encountered exception", new Object[0]);
            throw t2;
        }
    }

    public CompletionStage<Object> handleRequest(IndexRequest indexRequest) {
        this.flowableProcessors[indexRequest.getSegment()].onNext((Object)indexRequest);
        return indexRequest;
    }

    public void ensureRunOnLast(Runnable runnable) {
        AtomicInteger count = new AtomicInteger(this.flowableProcessors.length);
        IndexRequest request = IndexRequest.syncRequest(() -> {
            if (count.decrementAndGet() == 0) {
                runnable.run();
            }
        });
        for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
            flowableProcessor.onNext((Object)request);
        }
    }

    public void deleteFileAsync(int fileId) {
        this.ensureRunOnLast(() -> {
            this.dataFileProvider.deleteFile(fileId);
            this.compactor.releaseStats(fileId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> stop(long maxSeqId) throws InterruptedException {
        AggregateCompletionStage aggregateCompletionStage;
        long stamp = this.lock.readLock();
        try {
            for (FlowableProcessor<IndexRequest> flowableProcessor : this.flowableProcessors) {
                flowableProcessor.onComplete();
            }
            aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
            for (Segment segment : this.segments) {
                aggregateCompletionStage.dependsOn((CompletionStage)segment);
            }
            aggregateCompletionStage.dependsOn(this.removeSegmentsStage);
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return aggregateCompletionStage.freeze().thenRun(() -> {
            this.indexFileProvider.stop();
            try {
                this.indexSizeFile.createNewFile();
                try (FileOutputStream indexCountStream = new FileOutputStream(this.indexSizeFile);){
                    UnsignedNumeric.writeUnsignedInt((OutputStream)indexCountStream, (int)this.sizePerSegment.length());
                    for (int i = 0; i < this.sizePerSegment.length(); ++i) {
                        UnsignedNumeric.writeUnsignedLong((OutputStream)indexCountStream, (long)this.sizePerSegment.get(i));
                    }
                    UnsignedNumeric.writeUnsignedLong((OutputStream)indexCountStream, (long)maxSeqId);
                }
                ConcurrentMap<Integer, Compactor.Stats> map = this.compactor.getFileStats();
                File statsFile = new File(this.indexDir.toFile(), "index.stats");
                try (FileChannel statsChannel = new RandomAccessFile(statsFile, "rw").getChannel();){
                    statsChannel.truncate(0L);
                    java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(20);
                    for (Map.Entry entry : map.entrySet()) {
                        int file = (Integer)entry.getKey();
                        int total = ((Compactor.Stats)entry.getValue()).getTotal();
                        if (total == -1) {
                            total = (int)this.dataFileProvider.getFileSize(file);
                        }
                        int free = ((Compactor.Stats)entry.getValue()).getFree();
                        buffer.putInt(file);
                        buffer.putInt(total);
                        buffer.putInt(free);
                        buffer.putLong(((Compactor.Stats)entry.getValue()).getNextExpirationTime());
                        buffer.flip();
                        Index.write(statsChannel, buffer);
                        buffer.flip();
                    }
                }
            }
            catch (IOException e) {
                throw CompletableFutures.asCompletionException((Throwable)e);
            }
        });
    }

    public long approximateSize(IntSet cacheSegments) {
        long size = 0L;
        PrimitiveIterator.OfInt segIter = cacheSegments.iterator();
        while (segIter.hasNext()) {
            int cacheSegment = segIter.nextInt();
            if ((size += this.sizePerSegment.get(cacheSegment)) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return size;
    }

    public long getMaxSeqId() {
        return this.maxSeqId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOrCalculateMaxSeqId() throws IOException {
        if (this.maxSeqId > 0L) {
            return this.maxSeqId;
        }
        long maxSeqId = 0L;
        long stamp = this.lock.readLock();
        try {
            for (Segment seg : this.segments) {
                maxSeqId = Math.max(maxSeqId, IndexNode.calculateMaxSeqId(seg, seg.rootReadLock()));
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
        return maxSeqId;
    }

    public void start(IntSet segments) {
        this.addSegments(segments);
    }

    static boolean read(FileProvider.Handle handle, java.nio.ByteBuffer buffer, long offset) throws IOException {
        assert (buffer.hasRemaining());
        int read = 0;
        do {
            int newRead;
            if ((newRead = handle.read(buffer, offset + (long)read)) < 0) {
                return false;
            }
            read += newRead;
        } while (buffer.hasRemaining());
        return true;
    }

    static boolean read(FileChannel channel, java.nio.ByteBuffer buffer) throws IOException {
        assert (buffer.hasRemaining());
        do {
            int read;
            if ((read = channel.read(buffer)) >= 0) continue;
            return false;
        } while (buffer.position() < buffer.limit());
        return true;
    }

    private static long write(FileProvider.Handle handle, java.nio.ByteBuffer buffer, long offset) throws IOException {
        assert (buffer.hasRemaining());
        long write = 0L;
        while (buffer.hasRemaining()) {
            write += (long)handle.write(buffer, offset + write);
        }
        return write;
    }

    private static void write(FileChannel indexFile, java.nio.ByteBuffer buffer) throws IOException {
        assert (buffer.hasRemaining());
        do {
            int written;
            if ((written = indexFile.write(buffer)) >= 0) continue;
            throw new IllegalStateException("Cannot write to index file!");
        } while (buffer.position() < buffer.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> addSegments(IntSet addedSegments) {
        long stamp = this.lock.tryWriteLock();
        if (stamp != 0L) {
            try {
                this.actualAddSegments(addedSegments);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
            return CompletableFutures.completedNull();
        }
        return CompletableFuture.runAsync(() -> {
            long innerStamp = this.lock.writeLock();
            try {
                this.actualAddSegments(addedSegments);
            }
            finally {
                this.lock.unlockWrite(innerStamp);
            }
        }, this.executor);
    }

    private void traceSegmentsAdded(IntSet addedSegments) {
        IntSet actualAddedSegments = IntSets.mutableEmptySet((int)this.segments.length);
        PrimitiveIterator.OfInt segmentIter = addedSegments.iterator();
        while (segmentIter.hasNext()) {
            int i = segmentIter.nextInt();
            if (this.segments[i] != null && this.segments[i] != this.emptySegment) continue;
            actualAddedSegments.add(i);
        }
        log.tracef("Adding segments %s to SIFS index", actualAddedSegments);
    }

    private void actualAddSegments(IntSet addedSegments) {
        if (log.isTraceEnabled()) {
            this.traceSegmentsAdded(addedSegments);
        }
        PrimitiveIterator.OfInt segmentIter = addedSegments.iterator();
        while (segmentIter.hasNext()) {
            Segment segment;
            int i = segmentIter.nextInt();
            if (this.segments[i] != null && this.segments[i] != this.emptySegment) continue;
            UnicastProcessor flowableProcessor = UnicastProcessor.create((boolean)false);
            this.segments[i] = segment = new Segment(this, i, this.temporaryTable);
            this.flowableProcessors[i] = flowableProcessor.toSerialized();
            this.flowableProcessors[i].observeOn(Schedulers.from((Executor)this.executor)).subscribe((Consumer)segment, t -> {
                log.error("Error encountered with index, SIFS may not operate properly.", (Throwable)t);
                segment.completeExceptionally((Throwable)t);
            }, (Action)segment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> removeSegments(IntSet removedCacheSegments) {
        long stamp = this.lock.tryWriteLock();
        if (stamp != 0L) {
            try {
                this.actualRemoveSegments(removedCacheSegments);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
            return CompletableFutures.completedNull();
        }
        return CompletableFuture.runAsync(() -> {
            long innerStamp = this.lock.writeLock();
            try {
                this.actualRemoveSegments(removedCacheSegments);
            }
            finally {
                this.lock.unlockWrite(innerStamp);
            }
        }, this.executor);
    }

    private void actualRemoveSegments(IntSet removedCacheSegments) {
        log.tracef("Removing segments %s from index", removedCacheSegments);
        int addedCount = removedCacheSegments.size();
        ArrayList<Segment> removedSegments = new ArrayList<Segment>(addedCount);
        ArrayList<FlowableProcessor<IndexRequest>> removedFlowables = new ArrayList<FlowableProcessor<IndexRequest>>(addedCount);
        CompletableFuture<Void> stageWhenComplete = new CompletableFuture<Void>();
        PrimitiveIterator.OfInt iter = removedCacheSegments.iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (this.segments[i] == this.emptySegment) continue;
            removedSegments.add(this.segments[i]);
            this.segments[i] = this.emptySegment;
            removedFlowables.add(this.flowableProcessors[i]);
            this.flowableProcessors[i] = this.emptyFlowable;
            this.sizePerSegment.set(i, 0L);
        }
        this.removeSegmentsStage = stageWhenComplete;
        this.executor.execute(() -> {
            try {
                log.tracef("Cleaning old index information for segments: %s", removedCacheSegments);
                AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
                for (int offset = 0; offset < removedSegments.size(); ++offset) {
                    ((FlowableProcessor)removedFlowables.get(offset)).onComplete();
                    Segment segment = (Segment)removedSegments.get(offset);
                    stage.dependsOn(((CompletableFuture)segment.thenCompose(___ -> segment.root.publish((keyAndMetadataRecord, leafNode, fileProvider, timeService) -> {
                        this.compactor.free(leafNode.file, keyAndMetadataRecord.getHeader().totalLength());
                        return null;
                    }).ignoreElements().toCompletionStage(null))).thenRun(segment::delete));
                }
                stage.freeze().whenComplete((___, t) -> {
                    if (t != null) {
                        stageWhenComplete.completeExceptionally((Throwable)t);
                    } else {
                        stageWhenComplete.complete(null);
                    }
                });
            }
            catch (Throwable t2) {
                stageWhenComplete.completeExceptionally(t2);
            }
        });
    }

    <V> Flowable<EntryRecord> publish(IntSet cacheSegments, boolean loadValues) {
        return Flowable.fromIterable((Iterable)cacheSegments).concatMap(cacheSegment -> this.publish((int)cacheSegment, loadValues));
    }

    Flowable<EntryRecord> publish(int cacheSegment, boolean loadValues) {
        long stamp = this.lock.readLock();
        try {
            Segment segment = this.segments[cacheSegment];
            if (segment.index.sizePerSegment.get(cacheSegment) == 0L) {
                this.lock.unlockRead(stamp);
                return Flowable.empty();
            }
            return segment.root.publish((keyAndMetadataRecord, leafNode, fileProvider, currentTime) -> {
                long expiryTime = keyAndMetadataRecord.getHeader().expiryTime();
                if (expiryTime > 0L && expiryTime < currentTime || keyAndMetadataRecord.getHeader().valueLength() <= 0) {
                    return null;
                }
                if (loadValues) {
                    log.tracef("Loading value record for leafNode: %s", leafNode);
                    return leafNode.loadValue(keyAndMetadataRecord, fileProvider);
                }
                return keyAndMetadataRecord;
            }).doFinally(() -> this.lock.unlockRead(stamp));
        }
        catch (Throwable t) {
            this.lock.unlockRead(stamp);
            throw t;
        }
    }

    static class Segment
    extends CompletableFuture<Void>
    implements Consumer<IndexRequest>,
    Action {
        final Index index;
        private final TemporaryTable temporaryTable;
        private final TreeMap<Short, List<IndexSpace>> freeBlocks = new TreeMap();
        private final ReadWriteLock rootLock = new ReentrantReadWriteLock();
        private final int id;
        private long indexFileSize = 34L;
        private volatile IndexNode root;

        private Segment(Index index, int id, TemporaryTable temporaryTable) {
            this.index = index;
            this.temporaryTable = temporaryTable;
            this.id = id;
            this.root = IndexNode.emptyWithLeaves(this);
        }

        public int getId() {
            return this.id;
        }

        boolean load() throws IOException {
            FileProvider.Handle handle;
            int segmentMax = this.temporaryTable.getSegmentMax();
            try (FileProvider.Handle handle2 = handle = this.index.indexFileProvider.getFile(this.id);){
                boolean loaded;
                java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(34);
                if (handle.getFileSize() >= 34L && Index.read(handle, buffer, 0L) && buffer.getInt(0) == 1361759986 && buffer.getInt(4) == segmentMax) {
                    long rootOffset = buffer.getLong(8);
                    short rootOccupied = buffer.getShort(16);
                    long freeBlocksOffset = buffer.getLong(18);
                    this.root = new IndexNode(this, rootOffset, rootOccupied);
                    this.loadFreeBlocks(freeBlocksOffset);
                    this.indexFileSize = freeBlocksOffset;
                    loaded = true;
                } else {
                    loaded = handle.getFileSize() == 0L && this.index.sizePerSegment.get(this.id) == 0L;
                    handle.truncate(0L);
                    this.root = IndexNode.emptyWithLeaves(this);
                    this.indexFileSize = 34L;
                }
                buffer.putInt(0, -787319028);
                buffer.position(0);
                buffer.limit(4);
                Index.write(handle, buffer, 0L);
                boolean bl = loaded;
                return bl;
            }
        }

        void delete() {
            if (this.id >= 0) {
                log.tracef("Deleting file for index %s", this.id);
                this.index.indexFileProvider.deleteFile(this.id);
            }
        }

        void reset() throws IOException {
            try (FileProvider.Handle handle = this.index.indexFileProvider.getFile(this.id);){
                handle.truncate(0L);
                this.root = IndexNode.emptyWithLeaves(this);
                this.indexFileSize = 34L;
                java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(34);
                buffer.putInt(0, -787319028);
                buffer.position(0);
                buffer.limit(4);
                Index.write(handle, buffer, 0L);
            }
            this.freeBlocks.clear();
        }

        public void accept(IndexRequest request) throws Throwable {
            IndexNode.OverwriteHook overwriteHook;
            IndexNode.RecordChange recordChange;
            if (log.isTraceEnabled()) {
                log.tracef("Indexing %s", request);
            }
            switch (request.getType()) {
                case CLEAR: {
                    this.root = IndexNode.emptyWithLeaves(this);
                    try (FileProvider.Handle handle = this.index.indexFileProvider.getFile(this.id);){
                        handle.truncate(0L);
                    }
                    this.indexFileSize = 34L;
                    this.freeBlocks.clear();
                    this.index.nonBlockingManager.complete(request, null);
                    return;
                }
                case SYNC_REQUEST: {
                    Runnable runnable = (Runnable)request.getKey();
                    runnable.run();
                    this.index.nonBlockingManager.complete(request, null);
                    return;
                }
                case MOVED: {
                    recordChange = IndexNode.RecordChange.MOVE;
                    overwriteHook = this.index.movedHook;
                    break;
                }
                case UPDATE: {
                    recordChange = IndexNode.RecordChange.INCREASE;
                    overwriteHook = this.index.updateHook;
                    break;
                }
                case DROPPED: {
                    recordChange = IndexNode.RecordChange.DECREASE;
                    overwriteHook = this.index.droppedHook;
                    break;
                }
                case FOUND_OLD: {
                    recordChange = IndexNode.RecordChange.INCREASE_FOR_OLD;
                    overwriteHook = IndexNode.NOOP_HOOK;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(request.toString());
                }
            }
            try {
                IndexNode.setPosition(this.root, request, overwriteHook, recordChange);
            }
            catch (Throwable e) {
                request.completeExceptionally(e);
            }
            this.temporaryTable.removeConditionally(request.getSegment(), request.getKey(), request.getFile(), request.getOffset());
            if (request.getType() != IndexRequest.Type.UPDATE) {
                this.index.nonBlockingManager.complete(request, null);
            }
        }

        public void run() throws IOException {
            try {
                IndexSpace rootSpace = this.allocateIndexSpace(this.root.length());
                this.root.store(rootSpace);
                try (FileProvider.Handle handle = this.index.indexFileProvider.getFile(this.id);){
                    java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(4);
                    buffer.putInt(0, this.freeBlocks.size());
                    long offset = this.indexFileSize;
                    offset += Index.write(handle, buffer, offset);
                    for (Map.Entry<Short, List<IndexSpace>> entry : this.freeBlocks.entrySet()) {
                        List<IndexSpace> list = entry.getValue();
                        int requiredSize = 8 + list.size() * 10;
                        buffer = buffer.capacity() < requiredSize ? java.nio.ByteBuffer.allocate(requiredSize) : buffer;
                        buffer.position(0);
                        buffer.limit(requiredSize);
                        buffer.putInt(entry.getKey().shortValue());
                        buffer.putInt(list.size());
                        for (IndexSpace space : list) {
                            buffer.putLong(space.offset);
                            buffer.putShort(space.length);
                        }
                        buffer.flip();
                        offset += Index.write(handle, buffer, offset);
                    }
                    int headerWithoutMagic = 30;
                    buffer = buffer.capacity() < headerWithoutMagic ? java.nio.ByteBuffer.allocate(headerWithoutMagic) : buffer;
                    buffer.position(0);
                    buffer.limit(headerWithoutMagic);
                    buffer.putInt(this.index.segments.length);
                    buffer.putLong(rootSpace.offset);
                    buffer.putShort(rootSpace.length);
                    buffer.putLong(this.indexFileSize);
                    buffer.flip();
                    Index.write(handle, buffer, 4L);
                    buffer.position(0);
                    buffer.limit(4);
                    buffer.putInt(0, 1361759986);
                    Index.write(handle, buffer, 0L);
                }
                this.complete(null);
            }
            catch (Throwable t) {
                this.completeExceptionally(t);
            }
        }

        private void loadFreeBlocks(long freeBlocksOffset) throws IOException {
            java.nio.ByteBuffer buffer = java.nio.ByteBuffer.allocate(8);
            buffer.limit(4);
            long offset = freeBlocksOffset;
            try (FileProvider.Handle handle = this.index.indexFileProvider.getFile(this.id);){
                if (!Index.read(handle, buffer, offset)) {
                    throw new IOException("Cannot read free blocks lists!");
                }
                offset += 4L;
                int numLists = buffer.getInt(0);
                for (int i = 0; i < numLists; ++i) {
                    buffer.position(0);
                    buffer.limit(8);
                    if (!Index.read(handle, buffer, offset)) {
                        throw new IOException("Cannot read free blocks lists!");
                    }
                    offset += 8L;
                    int blockLength = buffer.getInt(0);
                    assert (blockLength <= Short.MAX_VALUE);
                    int listSize = buffer.getInt(4);
                    if (listSize <= 0) continue;
                    int requiredSize = 10 * listSize;
                    buffer = buffer.capacity() < requiredSize ? java.nio.ByteBuffer.allocate(requiredSize) : buffer;
                    buffer.position(0);
                    buffer.limit(requiredSize);
                    if (!Index.read(handle, buffer, offset)) {
                        throw new IOException("Cannot read free blocks lists!");
                    }
                    offset += (long)requiredSize;
                    buffer.flip();
                    ArrayList<IndexSpace> list = new ArrayList<IndexSpace>(listSize);
                    for (int j = 0; j < listSize; ++j) {
                        list.add(new IndexSpace(buffer.getLong(), buffer.getShort()));
                    }
                    this.freeBlocks.put((short)blockLength, list);
                }
            }
        }

        public FileProvider.Handle getIndexFile() throws IOException {
            return this.index.indexFileProvider.getFile(this.id);
        }

        public void forceIndexIfOpen(boolean metaData) throws IOException {
            FileProvider.Handle handle = this.index.indexFileProvider.getFileIfOpen(this.id);
            if (handle != null) {
                try (FileProvider.Handle handle2 = handle;){
                    handle.force(metaData);
                }
            }
        }

        public FileProvider getFileProvider() {
            return this.index.dataFileProvider;
        }

        public Compactor getCompactor() {
            return this.index.compactor;
        }

        public IndexNode getRoot() {
            return this.root;
        }

        public void setRoot(IndexNode root) {
            this.rootLock.writeLock().lock();
            this.root = root;
            this.rootLock.writeLock().unlock();
        }

        public int getMaxNodeSize() {
            return this.index.maxNodeSize;
        }

        public int getMinNodeSize() {
            return this.index.minNodeSize;
        }

        IndexSpace allocateIndexSpace(short length) {
            Map.Entry<Short, List<IndexSpace>> entry;
            short spaceLength;
            Iterator<Map.Entry<Short, List<IndexSpace>>> iter = this.freeBlocks.tailMap(length).entrySet().iterator();
            while (iter.hasNext() && length + (length >> 2) >= (spaceLength = (entry = iter.next()).getKey().shortValue())) {
                List<IndexSpace> list = entry.getValue();
                if (!list.isEmpty()) {
                    IndexSpace spaceToReturn = list.remove(list.size() - 1);
                    if (list.isEmpty()) {
                        iter.remove();
                    }
                    return spaceToReturn;
                }
                iter.remove();
            }
            long oldSize = this.indexFileSize;
            this.indexFileSize += (long)length;
            return new IndexSpace(oldSize, length);
        }

        void freeIndexSpace(long offset, short length) {
            if (length <= 0) {
                throw new IllegalArgumentException("Offset=" + offset + ", length=" + length);
            }
            if (offset + (long)length < this.indexFileSize) {
                this.freeBlocks.computeIfAbsent(length, k -> new ArrayList()).add(new IndexSpace(offset, length));
            } else {
                this.indexFileSize -= (long)length;
                try (FileProvider.Handle handle = this.index.indexFileProvider.getFile(this.id);){
                    handle.truncate(this.indexFileSize);
                }
                catch (IOException e) {
                    log.cannotTruncateIndex(e);
                }
            }
        }

        Lock rootReadLock() {
            return this.rootLock.readLock();
        }

        public TimeService getTimeService() {
            return this.index.timeService;
        }
    }

    static class IndexSpace {
        protected long offset;
        protected short length;

        IndexSpace(long offset, short length) {
            this.offset = offset;
            this.length = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexSpace)) {
                return false;
            }
            IndexSpace innerNode = (IndexSpace)o;
            return this.length == innerNode.length && this.offset == innerNode.offset;
        }

        public int hashCode() {
            int result = (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.length;
            return result;
        }

        public String toString() {
            return String.format("[%d-%d(%d)]", this.offset, this.offset + (long)this.length, this.length);
        }
    }
}

