/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public final class ClientAuthenticationMethod
implements Serializable {
    private static final long serialVersionUID = 620L;
    public static final ClientAuthenticationMethod CLIENT_SECRET_BASIC = new ClientAuthenticationMethod("client_secret_basic");
    public static final ClientAuthenticationMethod CLIENT_SECRET_POST = new ClientAuthenticationMethod("client_secret_post");
    public static final ClientAuthenticationMethod CLIENT_SECRET_JWT = new ClientAuthenticationMethod("client_secret_jwt");
    public static final ClientAuthenticationMethod PRIVATE_KEY_JWT = new ClientAuthenticationMethod("private_key_jwt");
    public static final ClientAuthenticationMethod NONE = new ClientAuthenticationMethod("none");
    public static final ClientAuthenticationMethod TLS_CLIENT_AUTH = new ClientAuthenticationMethod("tls_client_auth");
    public static final ClientAuthenticationMethod SELF_SIGNED_TLS_CLIENT_AUTH = new ClientAuthenticationMethod("self_signed_tls_client_auth");
    private final String value;

    public ClientAuthenticationMethod(String value) {
        Assert.hasText((String)value, (String)"value cannot be empty");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static ClientAuthenticationMethod[] methods() {
        return new ClientAuthenticationMethod[]{CLIENT_SECRET_BASIC, CLIENT_SECRET_POST, CLIENT_SECRET_JWT, PRIVATE_KEY_JWT, NONE, TLS_CLIENT_AUTH, SELF_SIGNED_TLS_CLIENT_AUTH};
    }

    @NonNull
    public static ClientAuthenticationMethod valueOf(String method) {
        for (ClientAuthenticationMethod m : ClientAuthenticationMethod.methods()) {
            if (!m.getValue().equals(method)) continue;
            return m;
        }
        return new ClientAuthenticationMethod(method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClientAuthenticationMethod that = (ClientAuthenticationMethod)obj;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return this.value;
    }
}

